#include "../../lvgl.h"

/*******************************************************************************
 * Size: 22 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 22 --font ./Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome.ttf -r 61441,61448,61451,61452,61453,61457,61459,61460,61461,61465,61468,61473,61478,61479,61480,61502,61504,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62099 --format lvgl -o lv_font_roboto_22.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_22
#define LV_FONT_ROBOTO_22 1
#endif

#if LV_FONT_ROBOTO_22

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x2a, 0x90, 0x3f, 0xd0, 0x2f, 0xd0, 0x2f, 0xd0,
    0x2f, 0xd0, 0x2f, 0xc0, 0x2f, 0xc0, 0x1f, 0xc0,
    0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xb0, 0x9, 0x70,
    0x0, 0x0, 0x1, 0x0, 0x2f, 0xe0, 0x2f, 0xe0,
    0x0, 0x0,

    /* U+22 "\"" */
    0x37, 0x4, 0x68, 0xf0, 0x9d, 0x8e, 0xa, 0xd8,
    0xd0, 0xab, 0x8c, 0xa, 0xa6, 0x80, 0x87,

    /* U+23 "#" */
    0x0, 0x0, 0x5, 0xa0, 0x1, 0xa4, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x5f, 0x30, 0x0, 0x0, 0xe,
    0x90, 0x8, 0xf0, 0x0, 0x0, 0x1, 0xf6, 0x0,
    0xbc, 0x0, 0x1, 0x33, 0x6f, 0x63, 0x3e, 0xb3,
    0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x2,
    0x55, 0xdd, 0x55, 0x9f, 0x75, 0x30, 0x0, 0xe,
    0xa0, 0x8, 0xf0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0x4f, 0x40, 0xe, 0xa0,
    0x0, 0x3d, 0xde, 0xfe, 0xdd, 0xfe, 0xdc, 0x2,
    0x99, 0xee, 0x99, 0xbf, 0xa9, 0x80, 0x0, 0xd,
    0xa0, 0x7, 0xf1, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0xad, 0x0, 0x0, 0x0, 0x4f, 0x40, 0xe, 0xa0,
    0x0, 0x0, 0x7, 0xf1, 0x1, 0xf7, 0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x13, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x30, 0x0,
    0x0, 0x1, 0x8d, 0xfc, 0x70, 0x0, 0x2, 0xef,
    0xfe, 0xff, 0xc0, 0x0, 0xcf, 0x90, 0x2, 0xdf,
    0x70, 0x1f, 0xe0, 0x0, 0x4, 0xfd, 0x3, 0xfc,
    0x0, 0x0, 0xf, 0xf0, 0x1f, 0xf1, 0x0, 0x0,
    0x33, 0x0, 0xbf, 0xd4, 0x0, 0x0, 0x0, 0x1,
    0xcf, 0xfd, 0x61, 0x0, 0x0, 0x0, 0x6c, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x3, 0xaf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe0, 0x79, 0x10, 0x0,
    0x0, 0xef, 0x2b, 0xf5, 0x0, 0x0, 0xe, 0xf2,
    0x6f, 0xd0, 0x0, 0x6, 0xfe, 0x0, 0xdf, 0xe9,
    0x8b, 0xff, 0x50, 0x1, 0x9f, 0xff, 0xfc, 0x50,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x2, 0x40, 0x0,
    0x0,

    /* U+25 "%" */
    0x4, 0xbc, 0x91, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfb, 0x7d, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xbc,
    0x0, 0x2f, 0x60, 0x1, 0xd2, 0x0, 0xd, 0x90,
    0x0, 0xf8, 0x0, 0xbd, 0x0, 0x0, 0xda, 0x0,
    0xf, 0x70, 0x5f, 0x30, 0x0, 0x9, 0xf2, 0x6,
    0xf3, 0xe, 0x90, 0x0, 0x0, 0x1c, 0xff, 0xf8,
    0x9, 0xe1, 0x0, 0x0, 0x0, 0x3, 0x52, 0x3,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x21,
    0xbf, 0xfa, 0x10, 0x0, 0x0, 0x1f, 0x70, 0xce,
    0x56, 0xea, 0x0, 0x0, 0xb, 0xd0, 0x2f, 0x50,
    0x7, 0xf0, 0x0, 0x5, 0xf3, 0x3, 0xf3, 0x0,
    0x5f, 0x20, 0x0, 0xe9, 0x0, 0x2f, 0x50, 0x6,
    0xf1, 0x0, 0x19, 0x10, 0x0, 0xdc, 0x23, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,

    /* U+26 "&" */
    0x0, 0x7, 0xbd, 0xa2, 0x0, 0x0, 0x0, 0xd,
    0xfe, 0xdf, 0xf4, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x4f, 0xc0, 0x0, 0x0, 0x9f, 0x60, 0x0, 0xef,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x3f, 0xe1, 0x2d, 0xf4, 0x0, 0x0, 0x0,
    0xaf, 0xcf, 0xf5, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0x50,
    0x0, 0x32, 0x2, 0xef, 0x63, 0xff, 0x30, 0x2f,
    0xa0, 0xaf, 0x80, 0x6, 0xfe, 0x15, 0xf8, 0xd,
    0xf2, 0x0, 0x8, 0xfc, 0xbf, 0x40, 0xdf, 0x30,
    0x0, 0xb, 0xff, 0xd0, 0x9, 0xfa, 0x0, 0x0,
    0x5f, 0xf9, 0x0, 0x1e, 0xfc, 0x87, 0xbf, 0xff,
    0xf5, 0x0, 0x1a, 0xff, 0xff, 0xb4, 0x3f, 0xf3,
    0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0,

    /* U+27 "'" */
    0x65, 0xdb, 0xea, 0xe9, 0xe8, 0x95,

    /* U+28 "(" */
    0x0, 0x0, 0x5, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0xa, 0xf4, 0x0, 0x4, 0xf8, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x5f, 0x70, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0xfd, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x5f, 0x90, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x8f, 0x50, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x9, 0xf4, 0x0, 0x0, 0xd,
    0xd0, 0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x3b,
    0x0,

    /* U+29 ")" */
    0x23, 0x0, 0x0, 0x7, 0xf4, 0x0, 0x0, 0xb,
    0xf3, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x7f,
    0x60, 0x0, 0x0, 0xfd, 0x0, 0x0, 0xa, 0xf4,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x8, 0xf5, 0x0, 0x0, 0xcf, 0x10, 0x0,
    0x2f, 0x90, 0x0, 0xa, 0xf2, 0x0, 0x5, 0xf6,
    0x0, 0x4, 0xf9, 0x0, 0x0, 0x58, 0x0, 0x0,
    0x0,

    /* U+2A "*" */
    0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x6e,
    0x92, 0xf8, 0x39, 0xc0, 0x5d, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2c, 0xff, 0x51, 0x0, 0x0, 0x3f,
    0xbf, 0x90, 0x0, 0x1, 0xee, 0x9, 0xf4, 0x0,
    0x5, 0xf4, 0x1, 0xeb, 0x0, 0x0, 0x20, 0x0,
    0x20, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x6, 0x66, 0x6e, 0xf8, 0x66, 0x63, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x17, 0x77, 0x7e, 0xf9,
    0x77, 0x74, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x71, 0x0, 0x0,

    /* U+2C "," */
    0x3, 0x51, 0xa, 0xf5, 0xa, 0xf4, 0xd, 0xf1,
    0x3f, 0xa0, 0x5d, 0x10, 0x0, 0x0,

    /* U+2D "-" */
    0x47, 0x77, 0x74, 0x9f, 0xff, 0xfa, 0x12, 0x22,
    0x21,

    /* U+2E "." */
    0x3, 0x15, 0xfe, 0x4f, 0xd0, 0x10,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x4a, 0x30, 0x0, 0x0, 0xb,
    0xf0, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x0, 0xce, 0x0, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x0, 0xb,
    0xf0, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0x0, 0x3, 0x50, 0x0, 0x0,
    0x0,

    /* U+30 "0" */
    0x0, 0x29, 0xcd, 0xb5, 0x0, 0x0, 0x4f, 0xfe,
    0xdf, 0xf9, 0x0, 0xe, 0xf5, 0x0, 0x2d, 0xf4,
    0x5, 0xfb, 0x0, 0x0, 0x5f, 0xa0, 0x8f, 0x60,
    0x0, 0x1, 0xfe, 0xb, 0xf5, 0x0, 0x0, 0xf,
    0xf0, 0xbf, 0x30, 0x0, 0x0, 0xef, 0x1c, 0xf3,
    0x0, 0x0, 0xd, 0xf1, 0xcf, 0x30, 0x0, 0x0,
    0xdf, 0x1c, 0xf3, 0x0, 0x0, 0xe, 0xf1, 0xbf,
    0x40, 0x0, 0x0, 0xff, 0x9, 0xf6, 0x0, 0x0,
    0xf, 0xf0, 0x6f, 0xa0, 0x0, 0x4, 0xfc, 0x1,
    0xff, 0x20, 0x0, 0xbf, 0x60, 0x8, 0xfe, 0x87,
    0xbf, 0xd0, 0x0, 0x7, 0xef, 0xff, 0xb1, 0x0,
    0x0, 0x0, 0x22, 0x10, 0x0, 0x0,

    /* U+31 "1" */
    0x0, 0x0, 0x5, 0x80, 0x2, 0x8e, 0xfd, 0x1d,
    0xff, 0xef, 0xd2, 0xfa, 0x42, 0xfd, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f,
    0xd0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2, 0xfd,

    /* U+32 "2" */
    0x0, 0x4a, 0xdd, 0xb5, 0x0, 0x0, 0x9f, 0xfe,
    0xdf, 0xfb, 0x0, 0x5f, 0xd3, 0x0, 0x2e, 0xf6,
    0xc, 0xf4, 0x0, 0x0, 0x6f, 0xb0, 0xff, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x4, 0xfe,
    0x10, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x2, 0xef, 0x40, 0x0, 0x0, 0x1, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0x0,
    0xbf, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xf9, 0x99,
    0x99, 0x99, 0x5b, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+33 "3" */
    0x0, 0x4a, 0xdd, 0xa4, 0x0, 0x9, 0xff, 0xdd,
    0xff, 0x90, 0x5f, 0xd2, 0x0, 0x2e, 0xf4, 0xbf,
    0x50, 0x0, 0x7, 0xf9, 0x67, 0x10, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x8, 0xf8, 0x0, 0x0,
    0x0, 0x4f, 0xe1, 0x0, 0xa, 0xce, 0xfc, 0x20,
    0x0, 0xa, 0xdf, 0xfd, 0x50, 0x0, 0x0, 0x0,
    0x4e, 0xf4, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x22,
    0x0, 0x0, 0x1, 0xfe, 0xef, 0x20, 0x0, 0x3,
    0xfd, 0xaf, 0x90, 0x0, 0xa, 0xf8, 0x2e, 0xfc,
    0x77, 0xcf, 0xd1, 0x2, 0xbf, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0x22, 0x0, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0x6, 0xa7, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xfa, 0x0, 0x0, 0x0, 0x7, 0xfc, 0xfa, 0x0,
    0x0, 0x0, 0x2f, 0xd5, 0xfa, 0x0, 0x0, 0x0,
    0xbf, 0x35, 0xfa, 0x0, 0x0, 0x6, 0xf8, 0x5,
    0xfa, 0x0, 0x0, 0x1e, 0xd0, 0x5, 0xfa, 0x0,
    0x0, 0xaf, 0x40, 0x5, 0xfa, 0x0, 0x5, 0xf9,
    0x0, 0x5, 0xfa, 0x0, 0x1e, 0xf5, 0x44, 0x47,
    0xfc, 0x43, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x26, 0x66, 0x66, 0x69, 0xfc, 0x65, 0x0, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0,

    /* U+35 "5" */
    0x0, 0xaa, 0xaa, 0xaa, 0xaa, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xf0, 0x3, 0xfb, 0x33, 0x33, 0x33,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x22, 0x0,
    0x0, 0x9, 0xfc, 0xff, 0xfe, 0x60, 0x0, 0xbf,
    0xfa, 0x9c, 0xff, 0x60, 0x3, 0x71, 0x0, 0x7,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x70, 0x21, 0x0, 0x0,
    0x9, 0xf7, 0x3f, 0xb0, 0x0, 0x0, 0xbf, 0x50,
    0xef, 0x30, 0x0, 0x4f, 0xf0, 0x5, 0xff, 0x97,
    0x9f, 0xf6, 0x0, 0x4, 0xdf, 0xff, 0xe5, 0x0,
    0x0, 0x0, 0x13, 0x20, 0x0, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x5, 0x8a, 0x10, 0x0, 0x0, 0x7f,
    0xff, 0xf1, 0x0, 0x0, 0x8f, 0xe7, 0x21, 0x0,
    0x0, 0x4f, 0xd1, 0x0, 0x0, 0x0, 0xb, 0xf3,
    0x0, 0x0, 0x0, 0x1, 0xfc, 0x1, 0x33, 0x0,
    0x0, 0x5f, 0xaa, 0xff, 0xfe, 0x50, 0x7, 0xff,
    0xf9, 0x69, 0xff, 0x40, 0x8f, 0xe2, 0x0, 0x7,
    0xfd, 0x9, 0xf7, 0x0, 0x0, 0xe, 0xf1, 0x9f,
    0x70, 0x0, 0x0, 0xbf, 0x37, 0xf9, 0x0, 0x0,
    0xb, 0xf4, 0x3f, 0xd0, 0x0, 0x0, 0xef, 0x10,
    0xcf, 0x70, 0x0, 0x7f, 0xc0, 0x3, 0xff, 0xa7,
    0xaf, 0xf3, 0x0, 0x3, 0xcf, 0xff, 0xc3, 0x0,
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0,

    /* U+37 "7" */
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x10, 0x0, 0x0,
    0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x29, 0xcd, 0xb5, 0x0, 0x0, 0x5f, 0xfe,
    0xdf, 0xfa, 0x0, 0x1f, 0xf6, 0x0, 0x2e, 0xf5,
    0x5, 0xfc, 0x0, 0x0, 0x6f, 0xa0, 0x6f, 0x90,
    0x0, 0x3, 0xfb, 0x4, 0xfc, 0x0, 0x0, 0x6f,
    0x90, 0xc, 0xf7, 0x0, 0x3e, 0xf2, 0x0, 0x1b,
    0xff, 0xef, 0xe4, 0x0, 0x3, 0xdf, 0xed, 0xff,
    0x60, 0x1, 0xef, 0x40, 0x1, 0xcf, 0x60, 0x8f,
    0x70, 0x0, 0x2, 0xfe, 0xb, 0xf3, 0x0, 0x0,
    0xe, 0xf1, 0xbf, 0x50, 0x0, 0x0, 0xff, 0x17,
    0xfc, 0x0, 0x0, 0x6f, 0xd0, 0xd, 0xfd, 0x87,
    0xbf, 0xf3, 0x0, 0x19, 0xff, 0xff, 0xc3, 0x0,
    0x0, 0x0, 0x23, 0x10, 0x0, 0x0,

    /* U+39 "9" */
    0x0, 0x3a, 0xdc, 0x92, 0x0, 0x7, 0xff, 0xde,
    0xff, 0x30, 0x3f, 0xf4, 0x0, 0x7f, 0xe0, 0x9f,
    0x70, 0x0, 0xb, 0xf6, 0xdf, 0x20, 0x0, 0x5,
    0xfa, 0xef, 0x10, 0x0, 0x2, 0xfc, 0xcf, 0x20,
    0x0, 0x1, 0xfe, 0x9f, 0x80, 0x0, 0x6, 0xfe,
    0x3f, 0xf5, 0x0, 0x6f, 0xfd, 0x7, 0xff, 0xef,
    0xfa, 0xfc, 0x0, 0x4a, 0xb9, 0x34, 0xf9, 0x0,
    0x0, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x0, 0x2f,
    0xe0, 0x0, 0x0, 0x4, 0xef, 0x50, 0x0, 0x7c,
    0xef, 0xf6, 0x0, 0x0, 0xbf, 0xc8, 0x20, 0x0,

    /* U+3A ":" */
    0x3, 0x15, 0xfe, 0x4f, 0xd0, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x5f,
    0xe4, 0xfd, 0x1, 0x0,

    /* U+3B ";" */
    0x0, 0x31, 0x5, 0xfe, 0x4, 0xfd, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x51, 0xa, 0xf5, 0xa, 0xf4,
    0xd, 0xf1, 0x3f, 0xa0, 0x5d, 0x10, 0x0, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x46, 0x0, 0x0, 0x0,
    0x5d, 0xf8, 0x0, 0x0, 0x7e, 0xff, 0xb3, 0x1,
    0x8e, 0xff, 0x92, 0x0, 0x2f, 0xfc, 0x60, 0x0,
    0x0, 0x3f, 0xfa, 0x40, 0x0, 0x0, 0x2, 0x9f,
    0xfd, 0x71, 0x0, 0x0, 0x1, 0x8f, 0xff, 0xa2,
    0x0, 0x0, 0x0, 0x6e, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x66,

    /* U+3D "=" */
    0x27, 0x77, 0x77, 0x77, 0x74, 0x5f, 0xff, 0xff,
    0xff, 0xf9, 0x14, 0x44, 0x44, 0x44, 0x42, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xf9, 0x4b, 0xbb,
    0xbb, 0xbb, 0xb6,

    /* U+3E ">" */
    0x65, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xe8, 0x10,
    0x0, 0x0, 0x3a, 0xff, 0xf9, 0x20, 0x0, 0x0,
    0x6, 0xcf, 0xfb, 0x40, 0x0, 0x0, 0x3, 0x9f,
    0xf8, 0x0, 0x0, 0x2, 0x9e, 0xf9, 0x0, 0x5,
    0xbf, 0xfc, 0x50, 0x29, 0xff, 0xfa, 0x30, 0x0,
    0x8f, 0xf9, 0x10, 0x0, 0x0, 0x66, 0x0, 0x0,
    0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x29, 0xbd, 0xb5, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x90, 0xd, 0xf8, 0x0, 0x4f, 0xf3, 0x2f,
    0xe0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0xc, 0xf4, 0x0, 0x0,
    0x0, 0x6f, 0xd0, 0x0, 0x0, 0x5, 0xff, 0x20,
    0x0, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x1, 0xff, 0x0, 0x0, 0x0,
    0x1, 0x98, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x0, 0x2, 0x45, 0x42, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xdf, 0xff, 0xff, 0xd6,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xa4, 0x21, 0x25,
    0xaf, 0xc0, 0x0, 0x0, 0x2e, 0xd3, 0x0, 0x0,
    0x0, 0x3, 0xec, 0x0, 0x0, 0xce, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x60, 0x6, 0xf4, 0x0,
    0x0, 0x69, 0x83, 0x0, 0x8, 0xd0, 0xd, 0xc0,
    0x0, 0x1d, 0xfc, 0xef, 0x70, 0x2, 0xf3, 0x2f,
    0x60, 0x0, 0xcf, 0x30, 0xf, 0x90, 0x0, 0xf6,
    0x7f, 0x10, 0x5, 0xf7, 0x0, 0x1f, 0x70, 0x0,
    0xc9, 0x9e, 0x0, 0xb, 0xf0, 0x0, 0x3f, 0x50,
    0x0, 0xc9, 0xbd, 0x0, 0xf, 0xc0, 0x0, 0x4f,
    0x40, 0x0, 0xca, 0xbc, 0x0, 0x1f, 0xa0, 0x0,
    0x6f, 0x20, 0x0, 0xd8, 0xbd, 0x0, 0x1f, 0x90,
    0x0, 0x8f, 0x10, 0x1, 0xf5, 0x9f, 0x0, 0xf,
    0xc0, 0x1, 0xef, 0x20, 0x7, 0xf1, 0x6f, 0x20,
    0xb, 0xf9, 0x6d, 0xcf, 0x91, 0x6f, 0x70, 0x2f,
    0x70, 0x2, 0xdf, 0xf9, 0x9, 0xff, 0xf7, 0x0,
    0xc, 0xe1, 0x0, 0x2, 0x10, 0x0, 0x12, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xc2, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x0, 0x4, 0xef, 0xc9, 0x88,
    0xbf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x5, 0xac,
    0xdc, 0xa6, 0x0, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x0, 0x8a, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xee, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x93, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf3, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x8f, 0x60, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x6f, 0x90, 0x0, 0x0, 0x9f, 0xec, 0xcc, 0xcd,
    0xfe, 0x0, 0x0, 0xf, 0xfe, 0xee, 0xee, 0xef,
    0xf5, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0x5f,
    0xb0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x2f, 0xf0, 0x0, 0x0, 0x0, 0x9, 0xf7,
    0x8, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0,

    /* U+42 "B" */
    0x2a, 0xaa, 0xaa, 0x97, 0x30, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x3f, 0xe1, 0x11, 0x15,
    0xdf, 0x90, 0x3f, 0xd0, 0x0, 0x0, 0x4f, 0xe0,
    0x3f, 0xd0, 0x0, 0x0, 0x1f, 0xf0, 0x3f, 0xd0,
    0x0, 0x0, 0x4f, 0xd0, 0x3f, 0xd0, 0x0, 0x4,
    0xef, 0x50, 0x3f, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x3f, 0xfa, 0xaa, 0xbd, 0xfd, 0x20, 0x3f, 0xd0,
    0x0, 0x0, 0x6f, 0xe0, 0x3f, 0xd0, 0x0, 0x0,
    0xc, 0xf5, 0x3f, 0xd0, 0x0, 0x0, 0xa, 0xf7,
    0x3f, 0xd0, 0x0, 0x0, 0xc, 0xf5, 0x3f, 0xd0,
    0x0, 0x0, 0x7f, 0xf1, 0x3f, 0xfa, 0xaa, 0xbe,
    0xff, 0x50, 0x3f, 0xff, 0xff, 0xfe, 0xa3, 0x0,

    /* U+43 "C" */
    0x0, 0x1, 0x8c, 0xdc, 0x92, 0x0, 0x0, 0x5,
    0xff, 0xfd, 0xff, 0xf7, 0x0, 0x4, 0xff, 0x60,
    0x0, 0x4e, 0xf5, 0x0, 0xdf, 0x50, 0x0, 0x0,
    0x5f, 0xd0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0xff,
    0x28, 0xf9, 0x0, 0x0, 0x0, 0x5, 0x61, 0xaf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x0, 0x0, 0x0, 0xd, 0xf3, 0x1f, 0xf2,
    0x0, 0x0, 0x2, 0xff, 0x0, 0x8f, 0xc1, 0x0,
    0x0, 0xcf, 0x80, 0x0, 0xbf, 0xe9, 0x89, 0xef,
    0xc0, 0x0, 0x0, 0x7e, 0xff, 0xfe, 0x80, 0x0,
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0,

    /* U+44 "D" */
    0x2a, 0xaa, 0xa9, 0x84, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xfd, 0x40, 0x0, 0x3f, 0xe1, 0x11,
    0x38, 0xff, 0x50, 0x3, 0xfd, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x3f, 0xd0, 0x0, 0x0, 0x9, 0xf8,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0x3f, 0xd0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0xff, 0x3, 0xfd, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0xef, 0x13, 0xfd, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x3f, 0xd0, 0x0, 0x0, 0x1, 0xfe, 0x3,
    0xfd, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x3f, 0xd0,
    0x0, 0x0, 0x1e, 0xf3, 0x3, 0xfd, 0x0, 0x0,
    0x3d, 0xf9, 0x0, 0x3f, 0xfa, 0xab, 0xef, 0xf9,
    0x0, 0x3, 0xff, 0xff, 0xfd, 0x93, 0x0, 0x0,

    /* U+45 "E" */
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0x63, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x3f, 0xe1, 0x11, 0x11, 0x11,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xee, 0xee, 0xee, 0x90, 0x3f, 0xfc, 0xcc, 0xcc,
    0xc8, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfb, 0xbb,
    0xbb, 0xbb, 0x83, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+46 "F" */
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0x53, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x3f, 0xe1, 0x11, 0x11, 0x11,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0x99, 0x99, 0x99, 0x40, 0x3f, 0xff, 0xff, 0xff,
    0xf7, 0x3, 0xfe, 0x11, 0x11, 0x11, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x2, 0x8c, 0xdc, 0x93, 0x0, 0x0, 0x6,
    0xff, 0xfd, 0xff, 0xf9, 0x0, 0x5, 0xff, 0x60,
    0x0, 0x4e, 0xf7, 0x0, 0xef, 0x50, 0x0, 0x0,
    0x4f, 0xf0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0xce,
    0x38, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x4c,
    0xcc, 0xcc, 0x4a, 0xf6, 0x0, 0x4, 0xdd, 0xdf,
    0xf5, 0x8f, 0x80, 0x0, 0x0, 0x0, 0xaf, 0x54,
    0xfd, 0x0, 0x0, 0x0, 0xa, 0xf5, 0xe, 0xf4,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x6f, 0xe3, 0x0,
    0x0, 0x1d, 0xf5, 0x0, 0x9f, 0xfb, 0x88, 0xaf,
    0xfc, 0x0, 0x0, 0x5c, 0xff, 0xff, 0xd7, 0x0,
    0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0,

    /* U+48 "H" */
    0x1a, 0x80, 0x0, 0x0, 0x0, 0x2a, 0x83, 0xfe,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0xd3, 0xfe, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3f,
    0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3f, 0xd3, 0xff, 0xee,
    0xee, 0xee, 0xef, 0xfd, 0x3f, 0xfc, 0xcc, 0xcc,
    0xcc, 0xdf, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3f, 0xd3,
    0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3f, 0xd3, 0xfe, 0x0, 0x0,
    0x0, 0x3, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3f, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x3, 0xfd,

    /* U+49 "I" */
    0xa, 0xa0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,
    0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x0, 0x6a, 0x40, 0x0, 0x0,
    0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x70, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x70, 0x0, 0x0, 0x0, 0x9,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x70, 0x0,
    0x0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x70, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x72, 0x53, 0x0, 0x0,
    0xa, 0xf6, 0x5f, 0xc0, 0x0, 0x0, 0xcf, 0x51,
    0xff, 0x30, 0x0, 0x5f, 0xf1, 0x8, 0xff, 0xa8,
    0xaf, 0xf7, 0x0, 0x7, 0xef, 0xff, 0xd6, 0x0,
    0x0, 0x0, 0x13, 0x10, 0x0, 0x0,

    /* U+4B "K" */
    0x2a, 0x90, 0x0, 0x0, 0x4, 0xaa, 0x13, 0xfd,
    0x0, 0x0, 0x3, 0xff, 0x50, 0x3f, 0xd0, 0x0,
    0x2, 0xef, 0x60, 0x3, 0xfd, 0x0, 0x1, 0xef,
    0x80, 0x0, 0x3f, 0xd0, 0x0, 0xdf, 0xa0, 0x0,
    0x3, 0xfd, 0x0, 0xcf, 0xb0, 0x0, 0x0, 0x3f,
    0xd0, 0xaf, 0xc0, 0x0, 0x0, 0x3, 0xfd, 0x9f,
    0xf6, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xef, 0xf2,
    0x0, 0x0, 0x3, 0xff, 0xe2, 0x9f, 0xd0, 0x0,
    0x0, 0x3f, 0xf2, 0x0, 0xdf, 0x90, 0x0, 0x3,
    0xfd, 0x0, 0x2, 0xff, 0x60, 0x0, 0x3f, 0xd0,
    0x0, 0x5, 0xff, 0x30, 0x3, 0xfd, 0x0, 0x0,
    0x9, 0xfd, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0xc,
    0xfa, 0x3, 0xfd, 0x0, 0x0, 0x0, 0x1e, 0xf6,

    /* U+4C "L" */
    0x1a, 0x90, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfb, 0xbb,
    0xbb, 0xbb, 0x33, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+4D "M" */
    0x2a, 0xa6, 0x0, 0x0, 0x0, 0x0, 0x4, 0xaa,
    0x43, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xf6, 0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0x63, 0xfe, 0xfb, 0x0, 0x0, 0x0, 0x8,
    0xfe, 0xf6, 0x3f, 0xbd, 0xf2, 0x0, 0x0, 0x0,
    0xef, 0x9f, 0x63, 0xfb, 0x7f, 0x80, 0x0, 0x0,
    0x5f, 0xa8, 0xf6, 0x3f, 0xc1, 0xfe, 0x0, 0x0,
    0xc, 0xf3, 0x9f, 0x63, 0xfc, 0xa, 0xf5, 0x0,
    0x2, 0xfd, 0x9, 0xf6, 0x3f, 0xd0, 0x3f, 0xb0,
    0x0, 0x8f, 0x60, 0xaf, 0x63, 0xfd, 0x0, 0xdf,
    0x20, 0xe, 0xf0, 0xa, 0xf6, 0x3f, 0xd0, 0x6,
    0xf8, 0x5, 0xf9, 0x0, 0xaf, 0x63, 0xfd, 0x0,
    0x1f, 0xe0, 0xcf, 0x30, 0xa, 0xf6, 0x3f, 0xd0,
    0x0, 0x9f, 0x7f, 0xc0, 0x0, 0xaf, 0x63, 0xfd,
    0x0, 0x3, 0xff, 0xf6, 0x0, 0xa, 0xf6, 0x3f,
    0xd0, 0x0, 0xc, 0xff, 0x0, 0x0, 0xaf, 0x63,
    0xfd, 0x0, 0x0, 0x6f, 0x90, 0x0, 0xa, 0xf6,

    /* U+4E "N" */
    0x2a, 0xa1, 0x0, 0x0, 0x0, 0x2a, 0x83, 0xff,
    0xa0, 0x0, 0x0, 0x3, 0xfd, 0x3f, 0xff, 0x40,
    0x0, 0x0, 0x3f, 0xd3, 0xff, 0xfe, 0x0, 0x0,
    0x3, 0xfd, 0x3f, 0xeb, 0xf9, 0x0, 0x0, 0x3f,
    0xd3, 0xfe, 0x2f, 0xf4, 0x0, 0x3, 0xfd, 0x3f,
    0xe0, 0x7f, 0xd0, 0x0, 0x3f, 0xd3, 0xfe, 0x0,
    0xcf, 0x80, 0x3, 0xfd, 0x3f, 0xe0, 0x2, 0xff,
    0x30, 0x3f, 0xd3, 0xfe, 0x0, 0x7, 0xfd, 0x3,
    0xfd, 0x3f, 0xe0, 0x0, 0xc, 0xf7, 0x3f, 0xd3,
    0xfe, 0x0, 0x0, 0x2f, 0xf6, 0xfd, 0x3f, 0xe0,
    0x0, 0x0, 0x8f, 0xef, 0xd3, 0xfe, 0x0, 0x0,
    0x0, 0xdf, 0xfd, 0x3f, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xd3, 0xfe, 0x0, 0x0, 0x0, 0x8, 0xfd,

    /* U+4F "O" */
    0x0, 0x1, 0x7c, 0xdc, 0x82, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x3, 0xff, 0x81,
    0x0, 0x6f, 0xf5, 0x0, 0xdf, 0x70, 0x0, 0x0,
    0x4f, 0xe0, 0x3f, 0xd0, 0x0, 0x0, 0x0, 0xbf,
    0x58, 0xf8, 0x0, 0x0, 0x0, 0x7, 0xf9, 0xaf,
    0x60, 0x0, 0x0, 0x0, 0x4f, 0xcb, 0xf5, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0xbf, 0x50, 0x0, 0x0,
    0x0, 0x3f, 0xda, 0xf5, 0x0, 0x0, 0x0, 0x3,
    0xfc, 0x9f, 0x70, 0x0, 0x0, 0x0, 0x5f, 0xb5,
    0xfc, 0x0, 0x0, 0x0, 0x9, 0xf7, 0xf, 0xf3,
    0x0, 0x0, 0x1, 0xff, 0x20, 0x7f, 0xd2, 0x0,
    0x1, 0xcf, 0x90, 0x0, 0xaf, 0xfb, 0x8a, 0xef,
    0xc0, 0x0, 0x0, 0x6d, 0xff, 0xfe, 0x80, 0x0,
    0x0, 0x0, 0x1, 0x32, 0x0, 0x0, 0x0,

    /* U+50 "P" */
    0x2a, 0xaa, 0xaa, 0xa9, 0x61, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x3f, 0xe1, 0x11,
    0x13, 0x9f, 0xf4, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x8f, 0xc0, 0x3f, 0xd0, 0x0, 0x0, 0x1, 0xff,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x3f,
    0xd0, 0x0, 0x0, 0x4, 0xfe, 0x3, 0xfd, 0x0,
    0x0, 0x4, 0xef, 0x80, 0x3f, 0xfc, 0xcc, 0xdf,
    0xff, 0xb0, 0x3, 0xff, 0xdd, 0xdd, 0xca, 0x50,
    0x0, 0x3f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x2, 0x8c, 0xdc, 0x81, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x4, 0xff, 0x70,
    0x1, 0x7f, 0xf4, 0x0, 0xef, 0x50, 0x0, 0x0,
    0x6f, 0xd0, 0x5f, 0xc0, 0x0, 0x0, 0x0, 0xdf,
    0x49, 0xf7, 0x0, 0x0, 0x0, 0x8, 0xf8, 0xbf,
    0x40, 0x0, 0x0, 0x0, 0x6f, 0xac, 0xf3, 0x0,
    0x0, 0x0, 0x4, 0xfb, 0xdf, 0x30, 0x0, 0x0,
    0x0, 0x4f, 0xcc, 0xf4, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0xaf, 0x60, 0x0, 0x0, 0x0, 0x7f, 0x97,
    0xfa, 0x0, 0x0, 0x0, 0xb, 0xf5, 0x1f, 0xf2,
    0x0, 0x0, 0x2, 0xff, 0x10, 0x8f, 0xd1, 0x0,
    0x1, 0xdf, 0x80, 0x0, 0xbf, 0xfa, 0x8a, 0xff,
    0xa0, 0x0, 0x0, 0x7e, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0x31, 0x5f, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x16, 0x0,

    /* U+52 "R" */
    0x2a, 0xaa, 0xaa, 0x98, 0x40, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xc1, 0x0, 0x3f, 0xe1, 0x11,
    0x25, 0xdf, 0xc0, 0x3, 0xfd, 0x0, 0x0, 0x1,
    0xef, 0x30, 0x3f, 0xd0, 0x0, 0x0, 0xb, 0xf6,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x3f,
    0xd0, 0x0, 0x0, 0x1e, 0xf3, 0x3, 0xfd, 0x0,
    0x1, 0x4d, 0xfb, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x3, 0xff, 0xaa, 0xac, 0xfb, 0x0,
    0x0, 0x3f, 0xd0, 0x0, 0x1e, 0xf3, 0x0, 0x3,
    0xfd, 0x0, 0x0, 0x7f, 0xb0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0xef, 0x40, 0x3, 0xfd, 0x0, 0x0,
    0x6, 0xfd, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0xd,
    0xf6, 0x3, 0xfd, 0x0, 0x0, 0x0, 0x5f, 0xe0,

    /* U+53 "S" */
    0x0, 0x1, 0x8c, 0xdc, 0x93, 0x0, 0x0, 0x5,
    0xff, 0xfe, 0xff, 0xf9, 0x0, 0x2, 0xff, 0x70,
    0x0, 0x4d, 0xf7, 0x0, 0x8f, 0xa0, 0x0, 0x0,
    0x3f, 0xe0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0xdd,
    0x10, 0x7f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xff, 0xa4, 0x0, 0x0, 0x0, 0x0, 0x5b, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x0, 0x1, 0x6c, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x0,
    0x88, 0x0, 0x0, 0x0, 0xe, 0xf2, 0xf, 0xf2,
    0x0, 0x0, 0x0, 0xef, 0x20, 0x9f, 0xb1, 0x0,
    0x0, 0x6f, 0xe0, 0x0, 0xcf, 0xfa, 0x88, 0xcf,
    0xf4, 0x0, 0x0, 0x6d, 0xff, 0xff, 0xb3, 0x0,
    0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0,

    /* U+54 "T" */
    0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x67, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x1, 0x11, 0x17,
    0xf9, 0x11, 0x11, 0x0, 0x0, 0x0, 0x7f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0,

    /* U+55 "U" */
    0x5a, 0x50, 0x0, 0x0, 0x2, 0xa8, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd,
    0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd,
    0x8f, 0x80, 0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80,
    0x0, 0x0, 0x4, 0xfd, 0x8f, 0x80, 0x0, 0x0,
    0x4, 0xfd, 0x7f, 0x90, 0x0, 0x0, 0x5, 0xfc,
    0x4f, 0xd0, 0x0, 0x0, 0x8, 0xf9, 0xe, 0xf8,
    0x0, 0x0, 0x3f, 0xf3, 0x4, 0xff, 0xc9, 0x8b,
    0xff, 0x70, 0x0, 0x3b, 0xff, 0xff, 0xc5, 0x0,
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0,

    /* U+56 "V" */
    0x6a, 0x60, 0x0, 0x0, 0x0, 0x6, 0xa6, 0x4f,
    0xe0, 0x0, 0x0, 0x0, 0xe, 0xf4, 0xe, 0xf4,
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x8, 0xfa, 0x0,
    0x0, 0x0, 0x9f, 0x80, 0x2, 0xff, 0x0, 0x0,
    0x0, 0xef, 0x20, 0x0, 0xcf, 0x50, 0x0, 0x5,
    0xfc, 0x0, 0x0, 0x6f, 0xa0, 0x0, 0xa, 0xf7,
    0x0, 0x0, 0x1f, 0xf0, 0x0, 0xf, 0xf1, 0x0,
    0x0, 0xb, 0xf5, 0x0, 0x5f, 0xb0, 0x0, 0x0,
    0x5, 0xfb, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0,
    0xef, 0x11, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x66, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xbb,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0,

    /* U+57 "W" */
    0x2a, 0x80, 0x0, 0x0, 0xa, 0x90, 0x0, 0x0,
    0x1a, 0xa0, 0x1f, 0xf0, 0x0, 0x0, 0x4f, 0xf1,
    0x0, 0x0, 0x4f, 0xc0, 0xd, 0xf3, 0x0, 0x0,
    0x9f, 0xf5, 0x0, 0x0, 0x8f, 0x80, 0x9, 0xf7,
    0x0, 0x0, 0xde, 0xfa, 0x0, 0x0, 0xbf, 0x40,
    0x5, 0xfa, 0x0, 0x2, 0xfa, 0xde, 0x0, 0x0,
    0xff, 0x0, 0x1, 0xfe, 0x0, 0x6, 0xf6, 0x9f,
    0x20, 0x3, 0xfc, 0x0, 0x0, 0xdf, 0x20, 0xb,
    0xf1, 0x5f, 0x70, 0x6, 0xf8, 0x0, 0x0, 0x9f,
    0x50, 0xf, 0xc0, 0xf, 0xb0, 0xa, 0xf5, 0x0,
    0x0, 0x6f, 0x90, 0x4f, 0x80, 0xb, 0xf0, 0xe,
    0xf1, 0x0, 0x0, 0x2f, 0xd0, 0x9f, 0x30, 0x7,
    0xf4, 0x1f, 0xd0, 0x0, 0x0, 0xe, 0xf1, 0xde,
    0x0, 0x2, 0xf9, 0x5f, 0x90, 0x0, 0x0, 0xa,
    0xf5, 0xfa, 0x0, 0x0, 0xed, 0x8f, 0x50, 0x0,
    0x0, 0x6, 0xfc, 0xf5, 0x0, 0x0, 0x9f, 0xcf,
    0x10, 0x0, 0x0, 0x2, 0xff, 0xf1, 0x0, 0x0,
    0x5f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xef, 0xb0,
    0x0, 0x0, 0x1f, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,

    /* U+58 "X" */
    0x1a, 0xa3, 0x0, 0x0, 0x0, 0x5a, 0x90, 0x8,
    0xfd, 0x0, 0x0, 0x1, 0xef, 0x50, 0x0, 0xdf,
    0x70, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x4f, 0xf2,
    0x0, 0x4f, 0xf2, 0x0, 0x0, 0x9, 0xfc, 0x0,
    0xdf, 0x70, 0x0, 0x0, 0x1, 0xef, 0x68, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x8b, 0xfb, 0x0, 0x0, 0x0, 0x7, 0xfd,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x2f, 0xf4, 0x0,
    0x7f, 0xe1, 0x0, 0x0, 0xcf, 0xa0, 0x0, 0xc,
    0xf9, 0x0, 0x6, 0xfe, 0x10, 0x0, 0x2, 0xff,
    0x40, 0x1f, 0xf5, 0x0, 0x0, 0x0, 0x8f, 0xd0,

    /* U+59 "Y" */
    0x7a, 0x70, 0x0, 0x0, 0x0, 0x5a, 0x93, 0xff,
    0x20, 0x0, 0x0, 0xe, 0xf6, 0xa, 0xfa, 0x0,
    0x0, 0x7, 0xfd, 0x0, 0x2f, 0xf2, 0x0, 0x0,
    0xef, 0x40, 0x0, 0x9f, 0xa0, 0x0, 0x7f, 0xb0,
    0x0, 0x1, 0xef, 0x30, 0x1e, 0xf3, 0x0, 0x0,
    0x7, 0xfb, 0x8, 0xfa, 0x0, 0x0, 0x0, 0xe,
    0xf4, 0xff, 0x10, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0,

    /* U+5A "Z" */
    0x9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x1, 0x11, 0x11,
    0x11, 0x1d, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x1, 0xef, 0x50, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xfd, 0xaa, 0xaa, 0xaa,
    0xaa, 0x31, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+5B "[" */
    0x6e, 0xee, 0x87, 0xfe, 0xc7, 0x7f, 0x90, 0x7,
    0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f,
    0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9,
    0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90,
    0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7, 0xf9, 0x0,
    0x7f, 0x90, 0x7, 0xf9, 0x0, 0x7f, 0x90, 0x7,
    0xfa, 0x42, 0x7f, 0xff, 0xa2, 0x55, 0x53,

    /* U+5C "\\" */
    0x4a, 0x40, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0, 0x9,
    0xf4, 0x0, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0x0, 0x4, 0xf9, 0x0, 0x0, 0x0,
    0xe, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0x60, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xf2,
    0x0, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0,
    0x54,

    /* U+5D "]" */
    0xce, 0xee, 0x2a, 0xcf, 0xf2, 0x0, 0xdf, 0x20,
    0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0,
    0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd,
    0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf,
    0x20, 0xd, 0xf2, 0x0, 0xdf, 0x20, 0xd, 0xf2,
    0x0, 0xdf, 0x20, 0xd, 0xf2, 0x0, 0xdf, 0x24,
    0x4e, 0xf2, 0xef, 0xff, 0x24, 0x55, 0x50,

    /* U+5E "^" */
    0x0, 0x2, 0xa4, 0x0, 0x0, 0x0, 0x9f, 0xb0,
    0x0, 0x0, 0xe, 0xff, 0x20, 0x0, 0x6, 0xf9,
    0xf8, 0x0, 0x0, 0xcf, 0xd, 0xe0, 0x0, 0x3f,
    0x90, 0x6f, 0x50, 0xa, 0xf3, 0x1, 0xfc, 0x1,
    0xfc, 0x0, 0xa, 0xf3, 0x3, 0x10, 0x0, 0x13,
    0x10,

    /* U+5F "_" */
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x9a, 0xaa, 0xaa,
    0xaa, 0xa8,

    /* U+60 "`" */
    0x17, 0x71, 0x0, 0x8, 0xfa, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x9, 0x90,

    /* U+61 "a" */
    0x0, 0x3a, 0xcc, 0xa4, 0x0, 0x8, 0xff, 0xdd,
    0xff, 0x70, 0x4f, 0xd2, 0x0, 0x4f, 0xf1, 0x59,
    0x40, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0x1a,
    0xf5, 0x1, 0x8d, 0xff, 0xff, 0xf5, 0x1e, 0xfb,
    0x76, 0x5b, 0xf5, 0x9f, 0x80, 0x0, 0x9, 0xf5,
    0xcf, 0x30, 0x0, 0xa, 0xf5, 0xaf, 0x70, 0x0,
    0x4f, 0xf5, 0x4f, 0xfb, 0x8b, 0xff, 0xf7, 0x5,
    0xef, 0xfe, 0x77, 0xfa, 0x0, 0x2, 0x20, 0x0,
    0x0,

    /* U+62 "b" */
    0x37, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x8, 0xf7, 0x3a, 0xdc, 0x70,
    0x0, 0x8f, 0xcf, 0xfe, 0xff, 0xd1, 0x8, 0xff,
    0x70, 0x1, 0xcf, 0x90, 0x8f, 0x90, 0x0, 0x2,
    0xff, 0x8, 0xf7, 0x0, 0x0, 0xd, 0xf3, 0x8f,
    0x70, 0x0, 0x0, 0xbf, 0x48, 0xf7, 0x0, 0x0,
    0xa, 0xf5, 0x8f, 0x70, 0x0, 0x0, 0xcf, 0x48,
    0xf8, 0x0, 0x0, 0x1f, 0xf1, 0x8f, 0xe2, 0x0,
    0x8, 0xfb, 0x8, 0xfe, 0xf9, 0x8b, 0xff, 0x30,
    0x8f, 0x69, 0xff, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x22, 0x0, 0x0,

    /* U+63 "c" */
    0x0, 0x2, 0x9c, 0xda, 0x40, 0x0, 0x5, 0xff,
    0xed, 0xff, 0x80, 0x2, 0xff, 0x40, 0x3, 0xef,
    0x40, 0x9f, 0x80, 0x0, 0x5, 0xfa, 0xd, 0xf2,
    0x0, 0x0, 0x6, 0x40, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0,
    0x2a, 0x70, 0x5f, 0xc0, 0x0, 0x9, 0xf7, 0x0,
    0xaf, 0xd7, 0x7c, 0xfc, 0x0, 0x0, 0x8e, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x1, 0x76, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0x0, 0x4a, 0xdc, 0x62, 0xfd, 0x7, 0xff,
    0xee, 0xfd, 0xfd, 0x2f, 0xf5, 0x0, 0x3d, 0xfd,
    0x9f, 0x90, 0x0, 0x3, 0xfd, 0xdf, 0x30, 0x0,
    0x2, 0xfd, 0xff, 0x10, 0x0, 0x2, 0xfd, 0xff,
    0x0, 0x0, 0x2, 0xfd, 0xef, 0x20, 0x0, 0x2,
    0xfd, 0xaf, 0x60, 0x0, 0x2, 0xfd, 0x5f, 0xd1,
    0x0, 0xa, 0xfd, 0xb, 0xfe, 0x88, 0xdf, 0xfd,
    0x0, 0x9f, 0xff, 0xc3, 0xfd, 0x0, 0x1, 0x31,
    0x0, 0x0,

    /* U+65 "e" */
    0x0, 0x18, 0xcc, 0xa3, 0x0, 0x3, 0xef, 0xed,
    0xff, 0x60, 0x1e, 0xf5, 0x0, 0x3e, 0xf2, 0x8f,
    0x80, 0x0, 0x7, 0xf8, 0xcf, 0x30, 0x0, 0x3,
    0xfb, 0xff, 0xdd, 0xdd, 0xde, 0xfd, 0xff, 0xbb,
    0xbb, 0xbb, 0xba, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xbf, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xe2, 0x0,
    0x1, 0xb3, 0xa, 0xff, 0x86, 0x9e, 0xf4, 0x0,
    0x7e, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x22, 0x10,
    0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x59, 0xa6, 0x0, 0xa, 0xff, 0xf9,
    0x0, 0x3f, 0xe3, 0x0, 0x0, 0x6f, 0x90, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x39, 0xcf, 0xc9, 0x90,
    0x5e, 0xff, 0xfe, 0xe0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x8f, 0x70, 0x0,

    /* U+67 "g" */
    0x0, 0x4a, 0xdb, 0x60, 0x98, 0x7, 0xff, 0xee,
    0xfc, 0xfd, 0x2f, 0xf5, 0x0, 0x3d, 0xfd, 0x9f,
    0x90, 0x0, 0x3, 0xfd, 0xdf, 0x30, 0x0, 0x2,
    0xfd, 0xef, 0x10, 0x0, 0x2, 0xfd, 0xff, 0x0,
    0x0, 0x2, 0xfd, 0xef, 0x20, 0x0, 0x2, 0xfd,
    0xaf, 0x60, 0x0, 0x2, 0xfd, 0x5f, 0xe1, 0x0,
    0xa, 0xfd, 0xb, 0xfe, 0x88, 0xdf, 0xfd, 0x0,
    0x9f, 0xff, 0xc5, 0xfd, 0x0, 0x1, 0x31, 0x3,
    0xfc, 0x5, 0x0, 0x0, 0x9, 0xf9, 0x2f, 0xc4,
    0x12, 0x8f, 0xf2, 0x6, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x15, 0x88, 0x50, 0x0,

    /* U+68 "h" */
    0x37, 0x30, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x8f, 0x72, 0x9c, 0xc8, 0x10, 0x8f, 0xbf,
    0xfe, 0xff, 0xd0, 0x8f, 0xf8, 0x0, 0x2d, 0xf5,
    0x8f, 0xa0, 0x0, 0x7, 0xf9, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f,
    0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70,
    0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa,
    0x8f, 0x70, 0x0, 0x5, 0xfa,

    /* U+69 "i" */
    0x3c, 0x76, 0xfc, 0x5, 0x20, 0x0, 0x39, 0x65,
    0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f,
    0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa,

    /* U+6A "j" */
    0x0, 0x4d, 0x50, 0x9, 0xfa, 0x0, 0x16, 0x10,
    0x0, 0x0, 0x0, 0x49, 0x50, 0x7, 0xf8, 0x0,
    0x7f, 0x80, 0x7, 0xf8, 0x0, 0x7f, 0x80, 0x7,
    0xf8, 0x0, 0x7f, 0x80, 0x7, 0xf8, 0x0, 0x7f,
    0x80, 0x7, 0xf8, 0x0, 0x7f, 0x80, 0x7, 0xf8,
    0x0, 0x7f, 0x80, 0x7, 0xf8, 0x0, 0xbf, 0x6b,
    0xff, 0xe1, 0x6a, 0x81, 0x0,

    /* U+6B "k" */
    0x37, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x1, 0x99,
    0x20, 0x7f, 0x80, 0x0, 0xcf, 0x90, 0x7, 0xf8,
    0x0, 0xcf, 0xa0, 0x0, 0x7f, 0x80, 0xbf, 0xb0,
    0x0, 0x7, 0xf8, 0xaf, 0xb0, 0x0, 0x0, 0x7f,
    0xef, 0xf5, 0x0, 0x0, 0x7, 0xff, 0xef, 0xe1,
    0x0, 0x0, 0x7f, 0xd1, 0x9f, 0xc0, 0x0, 0x7,
    0xf8, 0x0, 0xcf, 0x80, 0x0, 0x7f, 0x80, 0x2,
    0xff, 0x40, 0x7, 0xf8, 0x0, 0x5, 0xfe, 0x10,
    0x7f, 0x80, 0x0, 0x9, 0xfc, 0x0,

    /* U+6C "l" */
    0x28, 0x55, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5,
    0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f,
    0xa5, 0xfa, 0x5f, 0xa5, 0xfa, 0x5f, 0xa5, 0xfa,
    0x5f, 0xa0,

    /* U+6D "m" */
    0x49, 0x33, 0xac, 0xc8, 0x0, 0x29, 0xcc, 0x92,
    0x8, 0xfc, 0xfe, 0xef, 0xfc, 0x5f, 0xfe, 0xff,
    0xe1, 0x8f, 0xf5, 0x0, 0x2e, 0xff, 0x90, 0x1,
    0xcf, 0x88, 0xf8, 0x0, 0x0, 0x8f, 0xd0, 0x0,
    0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0, 0x5f, 0xa0,
    0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0, 0x5f,
    0xa0, 0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x3, 0xfc, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x3f, 0xc8, 0xf7, 0x0,
    0x0, 0x5f, 0xa0, 0x0, 0x3, 0xfc,

    /* U+6E "n" */
    0x49, 0x32, 0x9c, 0xc8, 0x10, 0x8f, 0xaf, 0xfe,
    0xff, 0xd0, 0x8f, 0xf8, 0x0, 0x2d, 0xf5, 0x8f,
    0xa0, 0x0, 0x7, 0xf9, 0x8f, 0x70, 0x0, 0x5,
    0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70,
    0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa,
    0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f, 0x70, 0x0,
    0x5, 0xfa, 0x8f, 0x70, 0x0, 0x5, 0xfa, 0x8f,
    0x70, 0x0, 0x5, 0xfa,

    /* U+6F "o" */
    0x0, 0x1, 0x8c, 0xda, 0x50, 0x0, 0x0, 0x4f,
    0xfe, 0xdf, 0xfb, 0x0, 0x1, 0xef, 0x70, 0x1,
    0xcf, 0x90, 0x8, 0xf9, 0x0, 0x0, 0x1f, 0xf1,
    0xd, 0xf3, 0x0, 0x0, 0xa, 0xf6, 0xf, 0xf0,
    0x0, 0x0, 0x7, 0xf8, 0xf, 0xf0, 0x0, 0x0,
    0x7, 0xf8, 0xe, 0xf1, 0x0, 0x0, 0x9, 0xf7,
    0xa, 0xf6, 0x0, 0x0, 0xd, 0xf3, 0x4, 0xfe,
    0x10, 0x0, 0x7f, 0xc0, 0x0, 0x9f, 0xe8, 0x6a,
    0xff, 0x30, 0x0, 0x6, 0xef, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0,

    /* U+70 "p" */
    0x49, 0x33, 0xad, 0xc7, 0x0, 0x8, 0xfc, 0xfe,
    0xef, 0xfc, 0x0, 0x8f, 0xf5, 0x0, 0x2d, 0xf8,
    0x8, 0xf8, 0x0, 0x0, 0x4f, 0xe0, 0x8f, 0x70,
    0x0, 0x0, 0xdf, 0x38, 0xf7, 0x0, 0x0, 0xb,
    0xf4, 0x8f, 0x70, 0x0, 0x0, 0xbf, 0x58, 0xf7,
    0x0, 0x0, 0xc, 0xf3, 0x8f, 0x70, 0x0, 0x1,
    0xff, 0x18, 0xfd, 0x0, 0x0, 0x9f, 0xb0, 0x8f,
    0xfd, 0x87, 0xbf, 0xf2, 0x8, 0xf8, 0xaf, 0xff,
    0xd3, 0x0, 0x8f, 0x70, 0x2, 0x20, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x37, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x4a, 0xdc, 0x70, 0x97, 0x7, 0xff, 0xed,
    0xfd, 0xfc, 0x3f, 0xf5, 0x0, 0x2d, 0xfc, 0x9f,
    0x90, 0x0, 0x3, 0xfc, 0xdf, 0x30, 0x0, 0x2,
    0xfc, 0xff, 0x10, 0x0, 0x2, 0xfc, 0xff, 0x0,
    0x0, 0x2, 0xfc, 0xef, 0x20, 0x0, 0x2, 0xfc,
    0xbf, 0x60, 0x0, 0x2, 0xfc, 0x5f, 0xd1, 0x0,
    0x8, 0xfc, 0xb, 0xfd, 0x77, 0xbf, 0xfc, 0x0,
    0xaf, 0xff, 0xd6, 0xfc, 0x0, 0x1, 0x31, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x1, 0x76,

    /* U+72 "r" */
    0x49, 0x45, 0xbc, 0x18, 0xfc, 0xff, 0xf2, 0x8f,
    0xf8, 0x21, 0x8, 0xfa, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x8, 0xf7,
    0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x5b, 0xdc, 0x82, 0x0, 0xa, 0xff, 0xde,
    0xff, 0x40, 0x5f, 0xc1, 0x0, 0x8f, 0xd0, 0x8f,
    0x70, 0x0, 0xb, 0xc1, 0x6f, 0xd2, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xd9, 0x40, 0x0, 0x0, 0x39,
    0xef, 0xfd, 0x20, 0x0, 0x0, 0x2, 0x9f, 0xe0,
    0x99, 0x0, 0x0, 0xd, 0xf3, 0xcf, 0x60, 0x0,
    0xe, 0xf2, 0x3f, 0xfa, 0x68, 0xdf, 0xb0, 0x3,
    0xcf, 0xff, 0xf8, 0x0, 0x0, 0x1, 0x31, 0x0,
    0x0,

    /* U+74 "t" */
    0x0, 0x57, 0x10, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0xcf, 0x30, 0x8, 0x9e, 0xfa, 0x93, 0xde, 0xff,
    0xfe, 0x50, 0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x8, 0xfd,
    0x83, 0x0, 0x1d, 0xff, 0x60, 0x0, 0x2, 0x20,

    /* U+75 "u" */
    0x59, 0x40, 0x0, 0x3, 0x95, 0x8f, 0x70, 0x0,
    0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9, 0x8f,
    0x70, 0x0, 0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6,
    0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9, 0x8f, 0x70,
    0x0, 0x6, 0xf9, 0x8f, 0x70, 0x0, 0x6, 0xf9,
    0x7f, 0x80, 0x0, 0x6, 0xf9, 0x5f, 0xc0, 0x0,
    0xc, 0xf9, 0xe, 0xfc, 0x79, 0xef, 0xf9, 0x3,
    0xdf, 0xff, 0xb6, 0xf9, 0x0, 0x1, 0x31, 0x0,
    0x0,

    /* U+76 "v" */
    0x59, 0x40, 0x0, 0x0, 0x89, 0x13, 0xfc, 0x0,
    0x0, 0x2f, 0xd0, 0xd, 0xf1, 0x0, 0x7, 0xf7,
    0x0, 0x8f, 0x60, 0x0, 0xcf, 0x20, 0x2, 0xfc,
    0x0, 0x1f, 0xc0, 0x0, 0xc, 0xf1, 0x7, 0xf6,
    0x0, 0x0, 0x6f, 0x60, 0xcf, 0x10, 0x0, 0x1,
    0xfb, 0x1f, 0xb0, 0x0, 0x0, 0xb, 0xf8, 0xf5,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0,

    /* U+77 "w" */
    0x49, 0x50, 0x0, 0x6, 0x91, 0x0, 0x0, 0x98,
    0x3f, 0xb0, 0x0, 0xe, 0xf6, 0x0, 0x4, 0xfa,
    0xe, 0xf0, 0x0, 0x3f, 0xfb, 0x0, 0x8, 0xf6,
    0xa, 0xf4, 0x0, 0x8f, 0xcf, 0x0, 0xc, 0xf1,
    0x5, 0xf8, 0x0, 0xdc, 0x6f, 0x50, 0xf, 0xd0,
    0x1, 0xfc, 0x2, 0xf7, 0x1f, 0x90, 0x4f, 0x80,
    0x0, 0xcf, 0x17, 0xf2, 0xb, 0xe0, 0x8f, 0x30,
    0x0, 0x7f, 0x5c, 0xd0, 0x6, 0xf3, 0xce, 0x0,
    0x0, 0x2f, 0xaf, 0x80, 0x1, 0xf9, 0xfa, 0x0,
    0x0, 0xe, 0xff, 0x30, 0x0, 0xcf, 0xf5, 0x0,
    0x0, 0x9, 0xfe, 0x0, 0x0, 0x7f, 0xf1, 0x0,
    0x0, 0x5, 0xf9, 0x0, 0x0, 0x2f, 0xc0, 0x0,

    /* U+78 "x" */
    0x29, 0x90, 0x0, 0x2, 0x99, 0x0, 0xaf, 0x80,
    0x0, 0xbf, 0x80, 0x1, 0xef, 0x20, 0x4f, 0xd0,
    0x0, 0x5, 0xfb, 0xd, 0xf3, 0x0, 0x0, 0xb,
    0xfc, 0xf9, 0x0, 0x0, 0x0, 0x1e, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0x0,
    0x8f, 0xef, 0x60, 0x0, 0x0, 0x3f, 0xe2, 0xef,
    0x20, 0x0, 0xd, 0xf4, 0x6, 0xfb, 0x0, 0x9,
    0xfa, 0x0, 0xc, 0xf6, 0x3, 0xff, 0x10, 0x0,
    0x2f, 0xf2,

    /* U+79 "y" */
    0x69, 0x40, 0x0, 0x0, 0x99, 0x5, 0xfc, 0x0,
    0x0, 0x5f, 0xb0, 0xf, 0xf1, 0x0, 0xa, 0xf6,
    0x0, 0xaf, 0x70, 0x0, 0xef, 0x10, 0x4, 0xfc,
    0x0, 0x4f, 0xb0, 0x0, 0xe, 0xf1, 0x9, 0xf5,
    0x0, 0x0, 0x8f, 0x70, 0xdf, 0x0, 0x0, 0x3,
    0xfc, 0x3f, 0xa0, 0x0, 0x0, 0xd, 0xfa, 0xf4,
    0x0, 0x0, 0x0, 0x7f, 0xfe, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x90, 0x0, 0x0, 0x1, 0x3d, 0xf2,
    0x0, 0x0, 0x1, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0xa, 0xa4, 0x0, 0x0, 0x0, 0x0,

    /* U+7A "z" */
    0x9, 0x99, 0x99, 0x99, 0x98, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x1e, 0xf5,
    0x0, 0x0, 0x0, 0xb, 0xf8, 0x0, 0x0, 0x0,
    0x8, 0xfc, 0x0, 0x0, 0x0, 0x4, 0xfe, 0x20,
    0x0, 0x0, 0x1, 0xef, 0x40, 0x0, 0x0, 0x0,
    0xbf, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xc0, 0x0,
    0x0, 0x0, 0x4f, 0xe1, 0x0, 0x0, 0x0, 0xe,
    0xfc, 0x99, 0x99, 0x99, 0x10, 0xff, 0xff, 0xff,
    0xff, 0xf2,

    /* U+7B "{" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0xf0,
    0x0, 0x1, 0xdf, 0x70, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xd, 0xf1, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x28, 0xff, 0x30, 0x0, 0x5f, 0xf8, 0x0, 0x0,
    0x15, 0xdf, 0x50, 0x0, 0x0, 0x4f, 0xc0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0x0, 0x0, 0xaf, 0xa0, 0x0, 0x0, 0x6, 0xc0,

    /* U+7C "|" */
    0x1a, 0x42, 0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72,
    0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72, 0xf7, 0x2f,
    0x72, 0xf7, 0x2f, 0x72, 0xf7, 0x2f, 0x72, 0xf7,
    0x2f, 0x72, 0xf7, 0x1e, 0x70,

    /* U+7D "}" */
    0x0, 0x0, 0x0, 0x9, 0xd4, 0x0, 0x0, 0x3d,
    0xf5, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0xbf,
    0x40, 0x0, 0x9, 0xf6, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x4, 0xfc, 0x0, 0x0, 0xb, 0xfb, 0x50, 0x0,
    0x1e, 0xfb, 0x0, 0xd, 0xf8, 0x20, 0x5, 0xfa,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x3f, 0xd0, 0x0, 0x6f, 0xe2,
    0x0, 0x7, 0x91, 0x0, 0x0,

    /* U+7E "~" */
    0x0, 0x49, 0x83, 0x0, 0x0, 0x5, 0x20, 0x8f,
    0xff, 0xf9, 0x0, 0x3, 0xf6, 0x3f, 0xc3, 0x5d,
    0xfc, 0x32, 0xcf, 0x27, 0xf4, 0x0, 0xa, 0xff,
    0xff, 0x70, 0x35, 0x0, 0x0, 0x4, 0x9a, 0x40,
    0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x15, 0xaf, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x26, 0xbf, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x38, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xb6, 0xcd, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xb5, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0xb, 0xfe, 0x94, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xd0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x2, 0x8a, 0xa7, 0xcd, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x7, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0xff, 0xff, 0xff, 0xfd,
    0x1, 0x58, 0x85, 0xcd, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x85, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x7,
    0xcf, 0xeb, 0x60, 0xef, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef,
    0xfe, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F008 "" */
    0x2, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x10, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0xfd, 0x44, 0xaf, 0xa4, 0x44, 0x44, 0x44, 0x44,
    0x5e, 0xf5, 0x47, 0xf8, 0xf9, 0x0, 0x4f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0xf9,
    0xf9, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0xf9, 0xff, 0x99, 0xdf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0x9b, 0xf9,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xf9, 0xfb, 0x0, 0x7f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x2, 0xf9,
    0xf9, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0xf9, 0xfa, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x1, 0xf9,
    0xff, 0xed, 0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xef, 0xfe, 0xdf, 0xf9, 0xff, 0xcb, 0xef, 0xeb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xcf, 0xfd, 0xbd, 0xf9,
    0xfa, 0x0, 0x5f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0xf9, 0xf9, 0x0, 0x4f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0xf9,
    0xfc, 0x22, 0x9f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0x25, 0xf9, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xf9,
    0xfe, 0x66, 0xcf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf8, 0x69, 0xf9, 0xf9, 0x0, 0x4f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0xf9,
    0xf9, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0xf9, 0xee, 0x66, 0xcf, 0xc6,
    0x66, 0x66, 0x66, 0x66, 0x7f, 0xf8, 0x69, 0xf8,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x0, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F00B "" */
    0x14, 0x44, 0x42, 0x0, 0x24, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x41, 0xef, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0x42, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x42, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0x31,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x26,
    0x66, 0x64, 0x0, 0x36, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfe,
    0x10, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0x42, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x42, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x41, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x6b, 0xbb, 0xb9, 0x0, 0x8b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0xbb, 0xb9, 0x0, 0x8b, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb6, 0xff, 0xff, 0xff, 0x41, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x42, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x42, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xaf, 0xff, 0xfd, 0x10, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xb5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xf6,
    0x0, 0x14, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0x90, 0x1, 0xdf, 0xa0, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xf9, 0x0, 0x1d, 0xff, 0xf9, 0x0,
    0x2, 0xef, 0xff, 0xff, 0x90, 0x0, 0x7f, 0xff,
    0xff, 0x90, 0x2e, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xfa, 0xef, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2b,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x24, 0x0, 0x0, 0x0, 0x2, 0x30, 0x0,
    0x3e, 0xf8, 0x0, 0x0, 0x4, 0xff, 0x70, 0x3f,
    0xff, 0xf8, 0x0, 0x4, 0xff, 0xff, 0x69, 0xff,
    0xff, 0xf8, 0x4, 0xff, 0xff, 0xfe, 0x2e, 0xff,
    0xff, 0xfa, 0xff, 0xff, 0xff, 0x60, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x4, 0xff, 0xff, 0xff, 0x8e, 0xff,
    0xff, 0xf8, 0x9f, 0xff, 0xff, 0x60, 0x3e, 0xff,
    0xff, 0xe2, 0xef, 0xff, 0x60, 0x0, 0x3e, 0xff,
    0xf4, 0x2, 0xef, 0x60, 0x0, 0x0, 0x3e, 0xf5,
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x11, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x7c, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x70,
    0x2f, 0xff, 0x0, 0x89, 0x10, 0x0, 0x0, 0x3f,
    0xff, 0x32, 0xff, 0xf0, 0x5f, 0xfe, 0x20, 0x0,
    0x2f, 0xff, 0xf1, 0x2f, 0xff, 0x3, 0xff, 0xfe,
    0x0, 0xb, 0xff, 0xf4, 0x2, 0xff, 0xf0, 0x6,
    0xff, 0xf9, 0x3, 0xff, 0xf5, 0x0, 0x2f, 0xff,
    0x0, 0x7, 0xff, 0xf1, 0x9f, 0xfc, 0x0, 0x2,
    0xff, 0xf0, 0x0, 0xe, 0xff, 0x6d, 0xff, 0x60,
    0x0, 0x1f, 0xff, 0x0, 0x0, 0x8f, 0xfa, 0xef,
    0xf3, 0x0, 0x0, 0xbf, 0x90, 0x0, 0x5, 0xff,
    0xcf, 0xff, 0x20, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x5f, 0xfd, 0xdf, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xba, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf8, 0x5f, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x30, 0xdf,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xb0,
    0x4, 0xff, 0xfe, 0x50, 0x0, 0x0, 0x6f, 0xff,
    0xf2, 0x0, 0x7, 0xff, 0xff, 0xea, 0x9b, 0xef,
    0xff, 0xf5, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x2, 0xaf,
    0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x15, 0x78, 0x75, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x1, 0x44, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x60, 0x9, 0xff,
    0xf7, 0x0, 0x72, 0x0, 0x0, 0x4, 0xff, 0xb5,
    0xef, 0xff, 0xc5, 0xcf, 0xe1, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x10, 0x0, 0x3, 0xff, 0xff, 0xb2, 0x3,
    0xcf, 0xff, 0xf1, 0x0, 0xad, 0xff, 0xff, 0xc0,
    0x0, 0x1, 0xef, 0xff, 0xfc, 0x8f, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x8, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xde, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xfc, 0x1, 0x6f, 0xff, 0xf7, 0x0, 0x9,
    0xff, 0xff, 0x52, 0x0, 0x1, 0xff, 0xff, 0xfe,
    0xce, 0xff, 0xff, 0xe0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x6f, 0xfe, 0xaf, 0xff, 0xff, 0x9f, 0xff,
    0x60, 0x0, 0x0, 0x7b, 0x10, 0xaf, 0xff, 0x80,
    0x2c, 0x50, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x29, 0x99, 0x10, 0x0, 0x0, 0x0,

    /* U+F014 "" */
    0x0, 0x0, 0x0, 0x34, 0x44, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x94, 0x44, 0x5f,
    0x80, 0x0, 0x0, 0x12, 0x22, 0xaf, 0x32, 0x22,
    0x2d, 0xe2, 0x22, 0x20, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x5a, 0xf7, 0x66,
    0x66, 0x66, 0x66, 0x66, 0xed, 0x61, 0x6, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x6,
    0xf2, 0x3, 0x0, 0x30, 0x2, 0x10, 0xdb, 0x0,
    0x6, 0xf2, 0x4f, 0x42, 0xf6, 0xf, 0x90, 0xdb,
    0x0, 0x6, 0xf2, 0x4f, 0x42, 0xf6, 0xf, 0x90,
    0xdb, 0x0, 0x6, 0xf2, 0x4f, 0x42, 0xf6, 0xf,
    0x90, 0xdb, 0x0, 0x6, 0xf2, 0x4f, 0x42, 0xf6,
    0xf, 0x90, 0xdb, 0x0, 0x6, 0xf2, 0x4f, 0x42,
    0xf6, 0xf, 0x90, 0xdb, 0x0, 0x6, 0xf2, 0x4f,
    0x42, 0xf6, 0xf, 0x90, 0xdb, 0x0, 0x6, 0xf2,
    0x4f, 0x42, 0xf6, 0xf, 0x90, 0xdb, 0x0, 0x6,
    0xf2, 0x2a, 0x20, 0xa3, 0x9, 0x50, 0xdb, 0x0,
    0x6, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdb,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xea, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x28, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x50, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xa2, 0x0, 0x9b,
    0xb2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff,
    0xf5, 0xd, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x2d, 0xfd, 0x9f, 0xf7, 0xdf, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfc, 0x24, 0x6f, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x6f, 0xf9, 0x3e, 0xf9,
    0x4e, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x9f, 0xf7,
    0x5f, 0xff, 0xfb, 0x3d, 0xff, 0x50, 0x0, 0x1,
    0xbf, 0xf4, 0x7f, 0xff, 0xff, 0xfd, 0x3b, 0xff,
    0x50, 0x2, 0xdf, 0xd3, 0xaf, 0xff, 0xff, 0xff,
    0xfe, 0x49, 0xff, 0x70, 0x7f, 0xc3, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x66, 0xfe, 0x0, 0x60,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34,
    0x20, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xfb,
    0x44, 0x6f, 0xff, 0xff, 0x40, 0x0, 0x0, 0xd,
    0xff, 0xff, 0xa0, 0x3, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xfa, 0x0, 0x3f, 0xff,
    0xff, 0x40, 0x0, 0x0, 0xd, 0xff, 0xff, 0xa0,
    0x3, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfa, 0x0, 0x3f, 0xff, 0xff, 0x20, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0xcd, 0xdd, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x79, 0x9a, 0xff, 0xff, 0xd9, 0x99, 0x20,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x14, 0x44,
    0x44, 0x40, 0x2e, 0xf8, 0x2, 0x44, 0x44, 0x43,
    0xe, 0xff, 0xff, 0xff, 0xa0, 0x25, 0x4, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xa1,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,
    0xf6, 0x4f, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xdf, 0xdc, 0xf6, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,

    /* U+F01C "" */
    0x0, 0x4, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb3,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x6f, 0xfa, 0xaa, 0xaa,
    0xaa, 0xab, 0xff, 0x40, 0x0, 0xd, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x4, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x80, 0x2f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x9, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xf6, 0xef, 0xa1, 0x11, 0x0,
    0x0, 0x0, 0x1, 0x11, 0xcf, 0xbf, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0xb, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xdb, 0xbb, 0xdf, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x1, 0x34, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xff, 0xfb,
    0x40, 0x0, 0x34, 0x0, 0x3, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xc1, 0x4f, 0xd0, 0x4, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xef, 0xfd, 0x2, 0xff,
    0xff, 0x93, 0x0, 0x3, 0xaf, 0xff, 0xff, 0xd0,
    0xcf, 0xff, 0x40, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xfd, 0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xd9, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xfd, 0x69, 0x93, 0x0, 0x0,
    0x0, 0x0, 0x89, 0x99, 0x99, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x44, 0x44, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x24, 0x41, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0x6f, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xf1, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xfa, 0xf, 0xff,
    0xff, 0xe5, 0x0, 0x0, 0x6, 0xff, 0xff, 0x20,
    0xff, 0xff, 0xff, 0xfe, 0xa9, 0xbe, 0xff, 0xff,
    0x40, 0xf, 0xf6, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x40, 0x0, 0x95, 0x0, 0x2a, 0xff, 0xff,
    0xff, 0xf9, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x57, 0x87, 0x51, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x8, 0xf6, 0x0, 0x0, 0x0, 0x8f, 0xf6, 0x0,
    0x0, 0x8, 0xff, 0xf6, 0x0, 0x0, 0x8f, 0xff,
    0xf6, 0xdf, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x24,
    0x44, 0xbf, 0xff, 0xf6, 0x0, 0x0, 0xb, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0x0, 0xb, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x71,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xf6, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x89, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x8, 0xfa, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x9, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x8f, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x4f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xb, 0xd2, 0x2, 0x44, 0x4b, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x10, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x82,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf6, 0x0, 0x0, 0x2b, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x60, 0x4, 0x91, 0x9,
    0xf8, 0x0, 0x0, 0x0, 0x8, 0xff, 0xf6, 0x0,
    0x6f, 0xe3, 0xb, 0xf2, 0x0, 0x0, 0x8, 0xff,
    0xff, 0x60, 0x0, 0x3e, 0xe2, 0x1f, 0xa0, 0xdf,
    0xff, 0xff, 0xff, 0xf6, 0x8, 0x90, 0x2f, 0xa0,
    0xaf, 0xf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x8f,
    0xa0, 0x9f, 0x5, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x9f, 0x5, 0xf3, 0x3f, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x8, 0xf1, 0x5f, 0x32,
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x4, 0xfc,
    0x8, 0xf1, 0x4f, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0x60, 0xbd, 0x20, 0xec, 0x8, 0xf1, 0x24, 0x44,
    0xbf, 0xff, 0xf6, 0x0, 0x0, 0xbf, 0x40, 0xec,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0x60, 0x3, 0xdf,
    0x70, 0x8f, 0x50, 0x0, 0x0, 0x0, 0xbf, 0xf6,
    0x0, 0x6d, 0x40, 0x5f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x60, 0x0, 0x0, 0x7f, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x71, 0x0, 0x2, 0xdf,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3c, 0x60, 0x0, 0x0,

    /* U+F03E "" */
    0x2, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x10, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0xfb, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x45, 0xf8, 0xf9, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0xf9, 0x2, 0xdf, 0xd2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xf9, 0xb, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0xf9, 0xc, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x5d,
    0x20, 0x0, 0x0, 0xf9, 0xf9, 0x6, 0xff, 0xf6,
    0x0, 0x0, 0x5, 0xff, 0xd2, 0x0, 0x0, 0xf9,
    0xf9, 0x0, 0x48, 0x40, 0x0, 0x0, 0x5f, 0xff,
    0xfd, 0x20, 0x0, 0xf9, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xe2, 0x0, 0xf9,
    0xf9, 0x0, 0x0, 0x46, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xfd, 0x10, 0xf9, 0xf9, 0x0, 0x4, 0xff,
    0x65, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xf9,
    0xf9, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0xf9, 0xf9, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xf9,
    0xf9, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0xf9, 0xf9, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xf9,
    0xf9, 0x5, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x20, 0xf9, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x7, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x40,

    /* U+F040 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xe5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x26, 0x1d, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xf7, 0x1d, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x2e, 0xf9, 0xf7, 0x1d, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x2d, 0xf6, 0xcf, 0xf7,
    0x1d, 0xf3, 0x0, 0x0, 0x0, 0x2e, 0xf6, 0xdf,
    0xff, 0xf7, 0x13, 0x0, 0x0, 0x0, 0x2e, 0xf6,
    0xdf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x2d,
    0xf6, 0xcf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x2d, 0xf6, 0xcf, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x2d, 0xf6, 0xcf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x2e, 0xfd, 0xdf, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0xe, 0xf4, 0xcf, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xcf,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xf, 0xd9,
    0x10, 0xcf, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xf2, 0x2e, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x99, 0x99, 0x93, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F048 "" */
    0x24, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x99, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x9f, 0x9f, 0xff, 0x20, 0x0, 0x0,
    0x9f, 0xf9, 0xff, 0xf2, 0x0, 0x0, 0x9f, 0xff,
    0x9f, 0xff, 0x20, 0x0, 0x9f, 0xff, 0xf9, 0xff,
    0xf2, 0x0, 0x9f, 0xff, 0xff, 0x9f, 0xff, 0x20,
    0x9f, 0xff, 0xff, 0xf9, 0xff, 0xf2, 0x9f, 0xff,
    0xff, 0xff, 0x9f, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0x3c, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf2,
    0x1c, 0xff, 0xff, 0xff, 0x9f, 0xff, 0x20, 0x1c,
    0xff, 0xff, 0xf9, 0xff, 0xf2, 0x0, 0x1c, 0xff,
    0xff, 0x9f, 0xff, 0x20, 0x0, 0x1c, 0xff, 0xf9,
    0xff, 0xf2, 0x0, 0x0, 0x1c, 0xff, 0x9f, 0xff,
    0x20, 0x0, 0x0, 0x1c, 0xf9, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x1d, 0x96, 0x97, 0x0, 0x0, 0x0,
    0x0, 0x14,

    /* U+F04B "" */
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfd, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xfa, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xe6, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd5, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe5, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe7, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x10, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xfe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x82, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x24, 0x44, 0x44, 0x41, 0x0, 0x2, 0x44, 0x44,
    0x44, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x0, 0xff,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0xf, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xff, 0xff, 0xd0, 0x0, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xd0, 0x0, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0xf, 0xff, 0xff, 0xff, 0xdf, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xd0, 0x0, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xd6, 0x99, 0x99, 0x99,
    0x50, 0x0, 0x69, 0x99, 0x99, 0x95,

    /* U+F04D "" */
    0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd6, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x95,

    /* U+F051 "" */
    0x10, 0x0, 0x0, 0x0, 0x0, 0x44, 0xf, 0x30,
    0x0, 0x0, 0x0, 0x8f, 0xf8, 0xff, 0x30, 0x0,
    0x0, 0x9, 0xff, 0x9f, 0xff, 0x30, 0x0, 0x0,
    0x9f, 0xf9, 0xff, 0xff, 0x30, 0x0, 0x9, 0xff,
    0x9f, 0xff, 0xff, 0x30, 0x0, 0x9f, 0xf9, 0xff,
    0xff, 0xff, 0x30, 0x9, 0xff, 0x9f, 0xff, 0xff,
    0xff, 0x30, 0x9f, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0x39, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xcf,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xf7, 0x9f, 0xf9, 0xff, 0xff,
    0xff, 0xf7, 0x9, 0xff, 0x9f, 0xff, 0xff, 0xf7,
    0x0, 0x9f, 0xf9, 0xff, 0xff, 0xf7, 0x0, 0x9,
    0xff, 0x9f, 0xff, 0xf7, 0x0, 0x0, 0x9f, 0xf9,
    0xff, 0xf7, 0x0, 0x0, 0x9, 0xff, 0x9f, 0xf7,
    0x0, 0x0, 0x0, 0x9f, 0xf9, 0xf7, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x29, 0x92,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x3a, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x29, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x62, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0,

    /* U+F054 "" */
    0x0, 0x53, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xd2, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xd2, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x4, 0x44, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x6b, 0xbb, 0xbb, 0xef, 0xff,
    0xfb, 0xbb, 0xbb, 0x90, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xa0, 0x0,
    0x0, 0x0,

    /* U+F068 "" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x6b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0x90,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbb, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf9, 0x66,
    0x9f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf4, 0x0, 0x4f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x4f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf5,
    0x0, 0x5f, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xf5, 0x0, 0x6f, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xf6, 0x0, 0x6f,
    0xff, 0xff, 0x20, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xf9, 0x44, 0xaf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xfa, 0x44,
    0xaf, 0xff, 0xff, 0xfc, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x40,
    0xd, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xd0, 0x6f, 0xff, 0xff, 0xff, 0xfc,
    0x99, 0xcf, 0xff, 0xff, 0xff, 0xf6, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x28, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x82,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfc,
    0x0, 0xab, 0xba, 0x83, 0x0, 0x0, 0x1, 0x7a,
    0xbb, 0xbe, 0xff, 0xc0, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff,
    0xff, 0xff, 0xfa, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x56, 0x67, 0xcf, 0xfe, 0x3f, 0xff,
    0xe8, 0x66, 0x6d, 0xff, 0x80, 0x0, 0x0, 0xa,
    0xf5, 0xbf, 0xfd, 0x10, 0x0, 0xb, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0xc4, 0xff, 0xf4, 0x0, 0x0,
    0xb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff,
    0xc0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xfd, 0x30, 0x0,
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xf6, 0xc7, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x0,
    0x0, 0x2d, 0xff, 0xd4, 0xff, 0x40, 0x0, 0xb,
    0xfc, 0x0, 0xab, 0xbc, 0xff, 0xff, 0x4b, 0xff,
    0xfd, 0xbb, 0xbe, 0xff, 0xc0, 0xff, 0xff, 0xff,
    0xf7, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xfe, 0x50, 0x0, 0x3c, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x56, 0x65, 0x30, 0x0, 0x0,
    0x0, 0x25, 0x77, 0x6d, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xf7, 0x7f, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0x70, 0x7, 0xff, 0xff, 0xfc, 0x0,
    0xb, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xc0, 0xaf, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xfa, 0x9f, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xf9, 0xa, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xa0,
    0x0, 0x86, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x68, 0x0,

    /* U+F078 "" */
    0x0, 0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x12, 0x0, 0x3, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xef, 0x40, 0x4f, 0xff, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xf4, 0xcf, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x2, 0xef, 0xff, 0xfc,
    0x4f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0xf4, 0x3, 0xff, 0xff, 0xfe, 0x20, 0x2,
    0xef, 0xff, 0xff, 0x40, 0x0, 0x3f, 0xff, 0xff,
    0xe2, 0x2e, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xfe, 0xef, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x20,
    0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x0, 0x0, 0x0, 0x3, 0xf9, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x1e, 0xff, 0x70, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0xcf, 0xff, 0xf4,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0xa, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x60, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0xb, 0xff, 0x60, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x60, 0x0, 0x2, 0x2e, 0xff, 0x62,
    0x10, 0x0, 0x0, 0x0, 0xb, 0xff, 0x60, 0x0,
    0x0, 0xd, 0xff, 0x40, 0x0, 0x0, 0x0, 0x14,
    0x4c, 0xff, 0x94, 0x40, 0x0, 0xd, 0xff, 0x40,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0xd, 0xff, 0x40, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0xd, 0xff, 0x62,
    0x22, 0x22, 0x21, 0x6, 0xff, 0xff, 0xff, 0x20,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x9f, 0xff, 0xf4, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0xb, 0xff, 0x70, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x1, 0xc9, 0x0, 0x0,

    /* U+F07B "" */
    0x0, 0x34, 0x44, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0x72, 0x22, 0x22, 0x22,
    0x20, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x10, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x40,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xae,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xfe, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6b, 0xbb, 0xbb, 0x70, 0x24,
    0x44, 0x2, 0xbb, 0xbb, 0xba, 0x1f, 0xff, 0xff,
    0xff, 0x72, 0x22, 0x24, 0xdf, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xcf, 0xca, 0xf6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x57, 0xf7, 0x5f, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x49, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x98, 0x0,

    /* U+F095 "" */
    0x0, 0x13, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x5, 0xff, 0xfd,
    0x30, 0x0, 0xdf, 0x81, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xf9, 0x2b, 0xff, 0xfe, 0x60, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0xff,
    0xb4, 0x0,

    /* U+F0C4 "" */
    0x1, 0x8a, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0xcf, 0xa4,
    0x5b, 0xff, 0x70, 0x0, 0x0, 0x0, 0x1, 0x9c,
    0xc4, 0xff, 0x0, 0x0, 0x5f, 0xf1, 0x0, 0x0,
    0x0, 0x7c, 0x40, 0x3e, 0xcf, 0x60, 0x0, 0xa,
    0xf5, 0x0, 0x0, 0x5c, 0x60, 0x3, 0xc3, 0x5f,
    0xf8, 0x10, 0xc, 0xf5, 0x0, 0x4c, 0x80, 0x0,
    0x7b, 0x10, 0x7, 0xff, 0xfe, 0xff, 0xec, 0x7a,
    0xa2, 0x0, 0xa, 0x80, 0x0, 0x0, 0x3a, 0xff,
    0xfe, 0xa6, 0xc3, 0x0, 0x2, 0xc5, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x6f, 0x3a, 0x50, 0x5c,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x13, 0x30, 0x9b,
    0x18, 0x48, 0xbc, 0x40, 0x0, 0x0, 0x0, 0x5c,
    0xff, 0xff, 0x91, 0x9b, 0xb7, 0x1, 0xb7, 0x0,
    0x0, 0x9, 0xff, 0xeb, 0xdf, 0xfc, 0x58, 0xd3,
    0x0, 0x8, 0xa0, 0x0, 0x6f, 0xf5, 0x0, 0xb,
    0xf5, 0x0, 0x2a, 0xa2, 0x0, 0x4c, 0x20, 0xdf,
    0x40, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x3c, 0x81,
    0x2, 0xc5, 0xff, 0x0, 0x0, 0x7f, 0xe1, 0x0,
    0x0, 0x0, 0x5c, 0x60, 0x4e, 0xcf, 0xb6, 0x8d,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xa2,
    0x2e, 0xff, 0xff, 0xd4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x68, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x6c, 0xdd, 0xdd, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xbb,
    0xbb, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0xbd, 0x0, 0x0, 0x6f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x80, 0xbd,
    0x0, 0x0, 0x6f, 0x21, 0x22, 0x22, 0x20, 0xa,
    0xf8, 0x0, 0xbd, 0x0, 0x0, 0x6f, 0xdf, 0xff,
    0xff, 0xfc, 0x7f, 0xe9, 0x99, 0xed, 0x0, 0x0,
    0x6f, 0xfd, 0x66, 0x66, 0xbf, 0xef, 0xff, 0xff,
    0xf8, 0x0, 0x2, 0xee, 0xeb, 0x0, 0x0, 0x9f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xe3, 0xdb,
    0x0, 0x0, 0x9f, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xee, 0x30, 0xdb, 0x0, 0x0, 0x9f, 0xf9, 0x0,
    0x0, 0x0, 0x2e, 0xe2, 0x0, 0xdb, 0x0, 0x0,
    0x9f, 0xf9, 0x0, 0x0, 0x0, 0xcf, 0xed, 0xdd,
    0xfb, 0x0, 0x0, 0x9f, 0xf9, 0x0, 0x0, 0x1,
    0xfd, 0xbb, 0xbb, 0xb3, 0x0, 0x0, 0x9f, 0xf9,
    0x0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf9, 0x0, 0x0, 0x2, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xfa, 0x22, 0x22,
    0x24, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xef, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x26, 0x66, 0x66, 0x67, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x2,
    0xfa, 0x66, 0x66, 0x66, 0x66, 0x66, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x2, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x20,

    /* U+F0C7 "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0xfb, 0x4e, 0xff, 0xfe, 0x44,
    0x5f, 0xbb, 0xf8, 0x0, 0xf, 0x90, 0xdf, 0xff,
    0xd0, 0x0, 0xf9, 0xa, 0xf8, 0x0, 0xf9, 0xd,
    0xff, 0xfd, 0x0, 0xf, 0x90, 0xa, 0xf8, 0xf,
    0x90, 0xdf, 0xff, 0xd0, 0x0, 0xf9, 0x0, 0xa,
    0xf5, 0xf9, 0xd, 0xff, 0xfe, 0x0, 0xf, 0x90,
    0x0, 0xd, 0xbf, 0x90, 0xdf, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0xbd, 0xf9, 0x3, 0x99, 0x99,
    0x99, 0x98, 0x10, 0x0, 0xb, 0xdf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xdf, 0x90, 0x4, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x0, 0xbd, 0xf9, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xb, 0xdf, 0x90, 0xdc, 0x44, 0x44,
    0x44, 0x44, 0x4e, 0xb0, 0xbd, 0xf9, 0xd, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xdb, 0xb, 0xdf, 0x90,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0xd, 0xb0, 0xbd,
    0xf9, 0xd, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xdb,
    0xb, 0xdf, 0x90, 0xdb, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xb0, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x93,

    /* U+F0E7 "" */
    0x0, 0x14, 0x44, 0x41, 0x0, 0x0, 0x9, 0xff,
    0xff, 0x70, 0x0, 0x0, 0xdf, 0xff, 0xf2, 0x0,
    0x0, 0x1f, 0xff, 0xfc, 0x0, 0x0, 0x5, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x9f, 0xff, 0xf1, 0x0,
    0x0, 0xd, 0xff, 0xfa, 0x15, 0x9d, 0xe1, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0x18, 0xff, 0xff, 0xff, 0xff, 0x90, 0xcf,
    0xff, 0xec, 0xff, 0xf2, 0xc, 0xa6, 0x20, 0x8f,
    0xfa, 0x0, 0x0, 0x0, 0xc, 0xff, 0x30, 0x0,
    0x0, 0x0, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x4f,
    0xf4, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0xf,
    0xd0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xa,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xff, 0xfd, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xea, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xba, 0xaf, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0xef, 0xb1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xfb, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0xf8, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0xf9, 0xd, 0xb0, 0xbd, 0x8, 0xf0, 0x6f, 0x14,
    0xf4, 0x1f, 0x60, 0xf9, 0xf9, 0x7, 0x60, 0x67,
    0x5, 0x90, 0x39, 0x12, 0x92, 0x2f, 0x60, 0xf9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x60, 0xf9, 0xf9, 0xb, 0xdd, 0x31,
    0xd5, 0xd, 0x70, 0xb9, 0x9, 0xef, 0x60, 0xf9,
    0xf9, 0x9, 0xbb, 0x21, 0xb4, 0xb, 0x60, 0x98,
    0x8, 0xbb, 0x40, 0xf9, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0xf9, 0x9, 0x80, 0x8b, 0xbb, 0xbb, 0xbb, 0xbb,
    0xb2, 0x1b, 0x40, 0xf9, 0xf9, 0xb, 0x90, 0x9d,
    0xdd, 0xdd, 0xdd, 0xdd, 0xd3, 0x1d, 0x50, 0xf9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0xfd, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xf8,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd2,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x4,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x8b, 0xbb, 0xbb, 0xbc, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x71, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0x8d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd0, 0x10, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6,
    0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x6f, 0x80, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xff, 0x80, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x6f, 0xff, 0x80, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x26,
    0x66, 0x66, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x0,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x43, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x8c, 0xff, 0xff, 0xff, 0xfc, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x50, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xc2, 0x0, 0x4, 0xef, 0xff, 0xfd, 0x83, 0x0,
    0x0, 0x2, 0x7c, 0xff, 0xff, 0xf6, 0x4, 0xff,
    0xff, 0xd4, 0x0, 0x26, 0x78, 0x76, 0x20, 0x3,
    0xcf, 0xff, 0xf6, 0xd, 0xff, 0x70, 0x7, 0xdf,
    0xff, 0xff, 0xff, 0xe8, 0x10, 0x6f, 0xfe, 0x20,
    0x1a, 0x40, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x2a, 0x20, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xdb, 0x9a, 0xcf, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xf9, 0x30, 0x0, 0x0,
    0x18, 0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x1c,
    0xc2, 0x3, 0x8c, 0xdc, 0x94, 0x1, 0xcd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xff,
    0xff, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xfd,
    0x74, 0x6c, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x0, 0x10, 0x4, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F240 "" */
    0x29, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0, 0xc, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xf8, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0xf, 0x90, 0x89, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x50,
    0xdb, 0x0, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xd, 0xe8,
    0xf, 0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0xad, 0xf3, 0xf9,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x4f, 0x4f, 0x90, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90, 0x4, 0xf4, 0xf9, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x4f, 0x4f, 0x90, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x4,
    0xf4, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x6, 0x9f, 0x4f,
    0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x90, 0xdf, 0xc0, 0xf9, 0xb,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xd8, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xed, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f,
    0x90, 0x4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,

    /* U+F241 "" */
    0x29, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0, 0xc, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xf8, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0xf, 0x90, 0x89, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x98, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xd, 0xe8,
    0xf, 0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0xad, 0xf3, 0xf9,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x4f, 0x4f, 0x90, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0xf9, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x4f, 0x4f, 0x90, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x6, 0x9f, 0x4f,
    0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0xf9, 0xb,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb0,
    0x0, 0x0, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xed, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f,
    0x90, 0x4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,

    /* U+F242 "" */
    0x29, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0, 0xc, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xf8, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0xf, 0x90, 0x89, 0x99, 0x99,
    0x99, 0x99, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0xd, 0xe8,
    0xf, 0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0xf3, 0xf9,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x4f, 0x90, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0xf9, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x4f, 0x90, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xf9, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0x9f, 0x4f,
    0x90, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0xf9, 0xb,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xed, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f,
    0x90, 0x4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,

    /* U+F243 "" */
    0x29, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0, 0xc, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xf8, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0xf, 0x90, 0x89, 0x99, 0x99,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0xf9, 0xd, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xe8,
    0xf, 0x90, 0xdf, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0xf3, 0xf9,
    0xd, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x4f, 0x90, 0xdf,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0xf9, 0xd, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x4f, 0x90, 0xdf, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xf9, 0xd, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x9f, 0x4f,
    0x90, 0xdf, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0xf9, 0xb,
    0xdd, 0xdd, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xed, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f,
    0x90, 0x4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,

    /* U+F244 "" */
    0x29, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x0, 0xc, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xf8, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xe8,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0xf3, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x4f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x9f, 0x4f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xed, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f,
    0x90, 0x4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x17, 0xbc, 0xdc, 0xa6, 0x10, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0x0, 0x0, 0x7f, 0xff, 0xfb, 0x7f, 0xff, 0xff,
    0x50, 0x0, 0x3f, 0xff, 0xff, 0xb0, 0x7f, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xfb, 0x0, 0x7f,
    0xff, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xb0, 0x10,
    0x7f, 0xff, 0xd0, 0x3f, 0xfe, 0x5d, 0xfb, 0xa,
    0x40, 0x7f, 0xff, 0x16, 0xff, 0xb0, 0x1d, 0xb0,
    0xad, 0x0, 0xdf, 0xf4, 0x8f, 0xff, 0xb0, 0x19,
    0x9, 0x20, 0xaf, 0xff, 0x69, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0xaf, 0xff, 0xf7, 0xaf, 0xff, 0xff,
    0xb0, 0x0, 0xaf, 0xff, 0xff, 0x8a, 0xff, 0xff,
    0xfe, 0x10, 0x1d, 0xff, 0xff, 0xf8, 0xaf, 0xff,
    0xfe, 0x20, 0x0, 0x1d, 0xff, 0xff, 0x79, 0xff,
    0xfe, 0x20, 0x60, 0x60, 0x1d, 0xff, 0xf6, 0x7f,
    0xfe, 0x20, 0xab, 0xa, 0xb0, 0x2e, 0xff, 0x54,
    0xff, 0xc1, 0xaf, 0xb0, 0xa8, 0x3, 0xff, 0xf2,
    0x1f, 0xff, 0xff, 0xfb, 0x4, 0x3, 0xff, 0xfe,
    0x0, 0xcf, 0xff, 0xff, 0xb0, 0x3, 0xff, 0xff,
    0x90, 0x5, 0xff, 0xff, 0xfb, 0x3, 0xff, 0xff,
    0xf3, 0x0, 0xb, 0xff, 0xff, 0xb3, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0xb, 0xff, 0xfd, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xff, 0xff,
    0xb4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x21,
    0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 87, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 91, .box_h = 17, .box_w = 4, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 34, .adv_w = 113, .box_h = 6, .box_w = 5, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 49, .adv_w = 219, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 153, .adv_w = 198, .box_h = 22, .box_w = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 274, .adv_w = 258, .box_h = 17, .box_w = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 402, .adv_w = 219, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 513, .adv_w = 61, .box_h = 6, .box_w = 2, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 519, .adv_w = 120, .box_h = 23, .box_w = 7, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 600, .adv_w = 122, .box_h = 23, .box_w = 7, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 681, .adv_w = 152, .box_h = 10, .box_w = 10, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 731, .adv_w = 200, .box_h = 12, .box_w = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 803, .adv_w = 69, .box_h = 7, .box_w = 4, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 817, .adv_w = 97, .box_h = 3, .box_w = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 826, .adv_w = 93, .box_h = 4, .box_w = 3, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 832, .adv_w = 145, .box_h = 18, .box_w = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 913, .adv_w = 198, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1007, .adv_w = 198, .box_h = 16, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1063, .adv_w = 198, .box_h = 16, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1151, .adv_w = 198, .box_h = 17, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1236, .adv_w = 198, .box_h = 16, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1332, .adv_w = 198, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1426, .adv_w = 197, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1520, .adv_w = 198, .box_h = 16, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1616, .adv_w = 198, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1710, .adv_w = 198, .box_h = 16, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1790, .adv_w = 85, .box_h = 13, .box_w = 3, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1810, .adv_w = 74, .box_h = 16, .box_w = 4, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1842, .adv_w = 179, .box_h = 10, .box_w = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1892, .adv_w = 193, .box_h = 7, .box_w = 10, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1927, .adv_w = 184, .box_h = 10, .box_w = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1977, .adv_w = 166, .box_h = 17, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2062, .adv_w = 316, .box_h = 21, .box_w = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2251, .adv_w = 230, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2371, .adv_w = 219, .box_h = 16, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2467, .adv_w = 229, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2578, .adv_w = 231, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2682, .adv_w = 200, .box_h = 16, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2770, .adv_w = 195, .box_h = 16, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2858, .adv_w = 240, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2969, .adv_w = 251, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3073, .adv_w = 96, .box_h = 16, .box_w = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3105, .adv_w = 194, .box_h = 17, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3199, .adv_w = 221, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3303, .adv_w = 189, .box_h = 16, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3391, .adv_w = 307, .box_h = 16, .box_w = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3527, .adv_w = 251, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3631, .adv_w = 242, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3742, .adv_w = 222, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3846, .adv_w = 242, .box_h = 19, .box_w = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3970, .adv_w = 217, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4074, .adv_w = 209, .box_h = 17, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4185, .adv_w = 210, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4289, .adv_w = 228, .box_h = 17, .box_w = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4391, .adv_w = 224, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4503, .adv_w = 312, .box_h = 16, .box_w = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4663, .adv_w = 221, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4775, .adv_w = 211, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4879, .adv_w = 211, .box_h = 16, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4983, .adv_w = 93, .box_h = 22, .box_w = 5, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5038, .adv_w = 144, .box_h = 18, .box_w = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5119, .adv_w = 93, .box_h = 22, .box_w = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5174, .adv_w = 147, .box_h = 9, .box_w = 9, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 5215, .adv_w = 159, .box_h = 2, .box_w = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5225, .adv_w = 109, .box_h = 4, .box_w = 6, .ofs_x = 0, .ofs_y = 13},
    {.bitmap_index = 5237, .adv_w = 191, .box_h = 13, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5302, .adv_w = 197, .box_h = 18, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5401, .adv_w = 184, .box_h = 13, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5473, .adv_w = 199, .box_h = 18, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5563, .adv_w = 186, .box_h = 13, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5628, .adv_w = 122, .box_h = 17, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5696, .adv_w = 197, .box_h = 17, .box_w = 10, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5781, .adv_w = 194, .box_h = 17, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5866, .adv_w = 85, .box_h = 16, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5890, .adv_w = 84, .box_h = 21, .box_w = 5, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 5943, .adv_w = 178, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6037, .adv_w = 85, .box_h = 17, .box_w = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6063, .adv_w = 309, .box_h = 12, .box_w = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6165, .adv_w = 194, .box_h = 12, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6225, .adv_w = 201, .box_h = 13, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6303, .adv_w = 197, .box_h = 17, .box_w = 11, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 6397, .adv_w = 200, .box_h = 17, .box_w = 10, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 6482, .adv_w = 119, .box_h = 12, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6524, .adv_w = 182, .box_h = 13, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6589, .adv_w = 115, .box_h = 16, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6645, .adv_w = 194, .box_h = 13, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6710, .adv_w = 171, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6776, .adv_w = 265, .box_h = 12, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6872, .adv_w = 174, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6938, .adv_w = 167, .box_h = 17, .box_w = 11, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 7032, .adv_w = 174, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7098, .adv_w = 119, .box_h = 22, .box_w = 8, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7186, .adv_w = 86, .box_h = 19, .box_w = 3, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7215, .adv_w = 119, .box_h = 22, .box_w = 7, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7292, .adv_w = 239, .box_h = 5, .box_w = 13, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 7325, .adv_w = 302, .box_h = 22, .box_w = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7534, .adv_w = 377, .box_h = 22, .box_w = 24, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7798, .adv_w = 352, .box_h = 18, .box_w = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7996, .adv_w = 352, .box_h = 15, .box_w = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8146, .adv_w = 277, .box_h = 16, .box_w = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8266, .adv_w = 302, .box_h = 21, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8466, .adv_w = 302, .box_h = 20, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8656, .adv_w = 277, .box_h = 20, .box_w = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8836, .adv_w = 327, .box_h = 16, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9004, .adv_w = 327, .box_h = 19, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9204, .adv_w = 302, .box_h = 16, .box_w = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9356, .adv_w = 302, .box_h = 20, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9546, .adv_w = 151, .box_h = 16, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9626, .adv_w = 226, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9746, .adv_w = 327, .box_h = 18, .box_w = 21, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9935, .adv_w = 377, .box_h = 20, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10175, .adv_w = 302, .box_h = 19, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10356, .adv_w = 201, .box_h = 20, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10486, .adv_w = 277, .box_h = 20, .box_w = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10666, .adv_w = 302, .box_h = 20, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10856, .adv_w = 302, .box_h = 20, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11046, .adv_w = 201, .box_h = 20, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11176, .adv_w = 302, .box_h = 16, .box_w = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11328, .adv_w = 251, .box_h = 21, .box_w = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11475, .adv_w = 251, .box_h = 21, .box_w = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11612, .adv_w = 277, .box_h = 18, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11774, .adv_w = 277, .box_h = 5, .box_w = 18, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 11819, .adv_w = 352, .box_h = 21, .box_w = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12050, .adv_w = 352, .box_h = 21, .box_w = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12281, .adv_w = 352, .box_h = 13, .box_w = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12411, .adv_w = 352, .box_h = 14, .box_w = 20, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 12551, .adv_w = 377, .box_h = 15, .box_w = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12731, .adv_w = 327, .box_h = 18, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12920, .adv_w = 327, .box_h = 21, .box_w = 21, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13141, .adv_w = 277, .box_h = 18, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13303, .adv_w = 352, .box_h = 18, .box_w = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13501, .adv_w = 352, .box_h = 23, .box_w = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13754, .adv_w = 302, .box_h = 20, .box_w = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13944, .adv_w = 176, .box_h = 22, .box_w = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14065, .adv_w = 352, .box_h = 23, .box_w = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14318, .adv_w = 377, .box_h = 15, .box_w = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14498, .adv_w = 277, .box_h = 18, .box_w = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14660, .adv_w = 302, .box_h = 23, .box_w = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14879, .adv_w = 402, .box_h = 18, .box_w = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15104, .adv_w = 453, .box_h = 16, .box_w = 29, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15336, .adv_w = 453, .box_h = 16, .box_w = 29, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15568, .adv_w = 453, .box_h = 16, .box_w = 29, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15800, .adv_w = 453, .box_h = 16, .box_w = 29, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16032, .adv_w = 453, .box_h = 16, .box_w = 29, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16264, .adv_w = 302, .box_h = 23, .box_w = 17, .ofs_x = 1, .ofs_y = -4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x13,
    0x14, 0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d,
    0x3f, 0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52,
    0x53, 0x66, 0x67, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xf2,
    0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241, 0x242,
    0x243, 0x292
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 61441, .range_length = 659, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY,
        .glyph_id_start = 96, .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 50
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Map glyph_ids to kern right classes*/
static uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Kern values between classes*/
static uint8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -18, 0, 0, 0,
    0, 0, 0, 0, -21, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -9, -10, 0, -3, -10, 0, -14, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 3, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -29, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -38, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -21, 0, 0, 0, 0, 0, 0, -10,
    0, -2, 0, 0, -22, -3, -15, -12,
    0, -16, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, -3, -2, -9, -6, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -4, 0, 0, -9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -18, 0, 0,
    0, -4, 0, 0, 0, -5, 0, -4,
    0, -4, -7, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -3, 0, 0, 0,
    -3, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, -40, 0, 0, 0, -29,
    0, -45, 0, 3, 0, 0, 0, 0,
    0, 0, 0, -6, -4, 0, 0, -4,
    -4, 0, 0, -4, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -5, 0,
    0, 0, 3, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -11, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -4,
    -5, 0, 0, 0, -4, -7, -11, 0,
    0, 0, 0, -58, 0, 0, 0, 0,
    0, 0, 0, 3, -11, 0, 0, -47,
    -9, -30, -25, 0, -41, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    -23, -16, 0, 0, 0, 0, 0, 0,
    0, 0, -56, 0, 0, 0, -24, 0,
    -34, 0, 0, 0, 0, 0, -5, 0,
    -4, 0, -2, -2, 0, 0, -2, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, -5,
    -3, 0, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -14, 0, -3, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, -37, -40, 0, 0, -14,
    -5, -41, -3, 3, 0, 3, 3, 0,
    3, 0, 0, -19, -17, 0, -19, -17,
    -13, -20, 0, -16, -12, -10, -13, -10,
    0, 0, 0, 0, 3, 0, -39, -6,
    0, 0, -13, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, -8, -8,
    0, 0, -8, -5, 0, 0, -5, -2,
    0, 0, 0, 3, 0, 0, 0, 3,
    0, -21, -10, 0, 0, -7, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    2, -6, -5, 0, 0, -5, -4, 0,
    0, -3, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -4, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -4, 0, 0, 0, -4, -5, 0, 0,
    0, 0, 0, 0, -5, 3, -8, -36,
    -9, 0, 0, -16, -5, -16, -3, 3,
    -16, 3, 3, 2, 3, 0, 3, -13,
    -11, -4, -7, -11, -7, -10, -4, -7,
    -3, 0, -4, -5, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -4, 0,
    0, 0, -3, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, -3, -3,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    3, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, -18, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -4, -3, 0, 0, 3, 0, 0, 0,
    -21, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, -3, 3, 0, -3, 0, 0, 9,
    0, 3, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -2,
    2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 2,
    .bpp = 4,

    .kern_scale = 16,
    .kern_dsc = &kern_classes,
    .kern_classes = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_22 = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 25,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if LV_FONT_ROBOTO_22*/

