//# Windows Server 2022

## 注意事項
1. 在 Linux 設定時，建議先不要刪除 `http` 的項目，結束安裝完後，如果考場沒有指定要保留的話，就直接刪除即可


## 大量創立使用者
```powershell
$path="CN=Users, DC=tcivs,DC=com, DC=tw"
$domain="tcivs.com.tw" # AD 網域
$user="AD" # 使用者開頭
$group="ADGroup" # 群族
$password="ADUserpassword" #密碼
$count=1..10 #多少？ 
foreach($i in $count) {
	$num=$i.ToString('00')
	New-AdUser -Name "$user$num" -SamAccountName "$user$num" -EmailAddress "$user$num@$domain" -Path $path -Enabled $True -PasswordNeverExpires $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString "$password" -AsPlainText -force)
	Add-ADGroupMember -Identity "$group" -Members "$user$num"
}
```
### 解釋

#### 變數定義

```
$path="CN=Users,DC=example,DC=com"
$domain="example.com"
$user="AD"
$group="ADGroup"
$password="ADUserpassword"
$count=1..10
```

$path：Active Directory 的預設 OU (組織單位) 路徑，這裡是 CN=Users,DC=example,DC=com。

$domain：網域名稱，如 example.com。

$user：使用者名稱的前綴。

$group：要加入的 AD 群組名稱。

$password：預設的使用者密碼。

$count：從 1 到 10 的數字序列，用於建立 10 個使用者。

#### 迴圈建立使用者

```
foreach($i in $count) {
    $num=$i.ToString('00')
```

使用 foreach 迴圈遍歷 $count，即 1 到 10。

`$i.ToString('00')`：將數字格式化為兩位數，01 至 10。

#### 建立 AD 使用者

```
New-AdUser -Name "$user$num" -SamAccountName "$user$num" -EmailAddress "$user$num@$domain" -Path $path -Enabled $True -PasswordNeverExpires $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString "$password" -AsPlainText -force)
```

New-AdUser：用於在 Active Directory 中建立新使用者。

-Name：使用者的全名 (顯示名稱)。

-SamAccountName：使用者登入名稱 (SAM 帳戶名稱)。

-EmailAddress：設定使用者的電子郵件地址。

-Path：將使用者建立於指定 OU (這裡是 CN=Users)。

-Enabled $True：啟用帳戶。

-PasswordNeverExpires $true：設定密碼永不過期。

-ChangePasswordAtLogon $false：設定使用者首次登入時不強制更改密碼。

-AccountPassword：設定使用者密碼。 `(ConvertTo-SecureString "$password" -AsPlainText -force)`：將密碼轉換為安全字串。

#### 加入群組

```
Add-ADGroupMember -Identity "$group" -Members "$user$num"
```

Add-ADGroupMember：將使用者加入指定的 AD 群組。

-Identity "$group"：指定群組名稱。

-Members "$user$num"：將新建立的使用者加入群組。

### 範例

```
$path="CN=Users,DC=school,DC=local"
$domain="school.local"
$user="student"
$group="StudentsGroup"
$password="SecureP@ss123"
$count=1..50
foreach($i in $count) {
 $num=$i.ToString('00')
 New-AdUser -Name "$user$num" -SamAccountName "$user$num" -EmailAddress "$user$num@$domain" -Path $path -Enabled $True -PasswordNeverExpires $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString "$password" -AsPlainText -force)
 Add-ADGroupMember -Identity "$group" -Members "$user$num"
}
```

這段程式碼會執行： 建立 50 個名為 student01 至 student50 的 AD 使用者。

使用者的密碼為 SecureP@ss123。

將這些使用者加入 StudentsGroup 群組。

### 注意
1. 群組已創立
2. 密碼安全性已關閉

## 關閉密碼安全性

## Windows 大量刪除使用者 (雙數)

```powershell
$path="CN=Users, DC=tcivs,DC=com, DC=tw" # 取代 ad 和 com 成 你的AD網域 如果不只兩個可以加 DC=
$domain="tcivs.com.tw" # AD 網域
$user="AD" # 使用者開頭
$count=1..10 #多少？
foreach($i in $count) {
 if ($i % 2 -eq 0) {
	 $num=$i.ToString('00')
	 Remove-AdUser -Identity "$user$num" -Confirm:$false
 }
}
```
### 解釋

#### 變數定義

```
$path="CN=Users,DC=ad,DC=com"
$domain="ad.com"
$user="AD"
$count=1..10
```

$path：Active Directory 使用者的組織單位 (OU) 路徑。你需要根據自己的 AD 網域結構來修改。

$domain：AD 網域名稱 (如 ad.com)。

$user：使用者名稱的前綴 (例如 AD，表示所有使用者的帳號名稱為 AD01, AD02, 等等)。

$count：指定要刪除的使用者範圍，這裡是 1 到 10。

#### 迴圈刪除使用者

```
foreach($i in $count) {
 if ($i % 2 -eq 0) {
	 $num=$i.ToString('00')
	 Remove-AdUser -Identity "$user$num" -Confirm:$false
 }
}
```

foreach：用於遍歷 $count 範圍 (1 到 10)，這會執行 10 次刪除操作。

`if (%i 2 -eq 0)`: 用來檢查 $i 是否能被 2 整除，若無餘數則表示 $i 是偶數。

`$i.ToString('00')`：將數字格式化為兩位數 (01, 02, ..., 10)。

Remove-AdUser：用於刪除指定的 Active Directory 使用者。

-Identity "$user$num"：指定要刪除的使用者名稱，這裡是 AD01, AD02, ..., AD10。

-Confirm:$false：防止在刪除使用者時顯示確認提示，讓操作非互動化。

### 範例

```
$path="CN=Users,DC=school,DC=local"
$domain="school.local"
$user="student"
$count=1..50
    foreach($i in $count) {
     if ($i % 2 -eq 0) {
        $num=$i.ToString('00')
        Remove-AdUser -Identity "$user$num" -Confirm:$false
     }
    }
```

這段程式碼會：

- 刪除 50 個名為 student01 至 student50 的使用者帳號。
- 在不顯示確認提示的情況下批量刪除這些使用者。

## Windows 大量刪除使用者 (單數)

```powershell
$path="CN=Users, DC=tcivs,DC=com, DC=tw" # 取代 ad 和 com 成 你的AD網域 如果不只兩個可以加 DC=
$domain="tcivs.com.tw" # AD 網域
$user="AD" # 使用者開頭
$count=1..10 #多少？
foreach($i in $count) {
 if (!($i % 2 -eq 0)) {
	 $num=$i.ToString('00')
	 Remove-AdUser -Identity "$user$num" -Confirm:$false
 }
}
```
### 解釋

#### 變數定義

```
$path="CN=Users,DC=ad,DC=com"
$domain="ad.com"
$user="AD"
$count=1..10
```
 
$path：Active Directory 使用者的組織單位 (OU) 路徑。你需要根據自己的 AD 網域結構來修改。

$domain：AD 網域名稱 (如 ad.com)。

$user：使用者名稱的前綴 (例如 AD，表示所有使用者的帳號名稱為 AD01, AD02, 等等)。

$count：指定要刪除的使用者範圍，這裡是 1 到 10。

#### 迴圈刪除使用者

```
foreach($i in $count) {
 if (!($i % 2 -eq 0)) {
	 $num=$i.ToString('00')
	 Remove-AdUser -Identity "$user$num" -Confirm:$false
 }
}
```

foreach：用於遍歷 $count 範圍 (1 到 10)，這會執行 10 次刪除操作。

`if (%i 2 -eq 0)`: 用來檢查 $i 是否能被 2 整除，若無餘數則表示 $i 是偶數。

`$i.ToString('00')`：將數字格式化為兩位數 (01, 02, ..., 10)。

Remove-AdUser：用於刪除指定的 Active Directory 使用者。

-Identity "$user$num"：指定要刪除的使用者名稱，這裡是 AD01, AD02, ..., AD10。

-Confirm:$false：防止在刪除使用者時顯示確認提示，讓操作非互動化。

### 範例

```
$path="CN=Users,DC=school,DC=local"
$domain="school.local"
$user="student"
$count=1..50
    foreach($i in $count) {
     if ($i % 2 -eq 0) {
        $num=$i.ToString('00')
        Remove-AdUser -Identity "$user$num" -Confirm:$false
     }
    }
```

這段程式碼會：

- 刪除 50 個名為 student01 至 student50 的使用者帳號。
- 在不顯示確認提示的情況下批量刪除這些使用者。
## Windows 大量刪除使用者

### 程式碼

```
$path="CN=Users, DC=ad,DC=com" # 取代 ad 和 com 成 你的AD網域
$domain="ad.com" # AD 網域
$user="AD" # 使用者開頭
$count=1..10 #多少？
foreach($i in $count) {
	$num=$i.ToString('00')
	Remove-AdUser -Identity "$user$num" -Confirm:$false
}
```

### 解釋

#### 變數定義

```
$path="CN=Users,DC=ad,DC=com"
$domain="ad.com"
$user="AD"
$count=1..10
```

$path：Active Directory 使用者的組織單位 (OU) 路徑。你需要根據自己的 AD 網域結構來修改。

$domain：AD 網域名稱 (如 ad.com)。

$user：使用者名稱的前綴 (例如 AD，表示所有使用者的帳號名稱為 AD01, AD02, 等等)。

$count：指定要刪除的使用者範圍，這裡是 1 到 10。

#### 迴圈刪除使用者

```
foreach($i in $count) {
    $num=$i.ToString('00')
    Remove-AdUser -Identity "$user$num" -Confirm:$false
}
```

foreach：用於遍歷 $count 範圍 (1 到 10)，這會執行 10 次刪除操作。

$i.ToString('00')：將數字格式化為兩位數 (01, 02, ..., 10)。

Remove-AdUser：用於刪除指定的 Active Directory 使用者。

-Identity "$user$num"：指定要刪除的使用者名稱，這裡是 AD01, AD02, ..., AD10。

-Confirm:$false：防止在刪除使用者時顯示確認提示，讓操作非互動化。

### 範例

```
$path="CN=Users,DC=school,DC=local"
$domain="school.local"
$user="student"
$count=1..50
foreach($i in $count) {
    $num=$i.ToString('00')
    Remove-AdUser -Identity "$user$num" -Confirm:$false
}
```

這段程式碼會：

- 刪除 50 個名為 student01 至 student50 的使用者帳號。
- 在不顯示確認提示的情況下批量刪除這些使用者。